#coding: utf-8
from django.db import models
from django.contrib import admin
from django import forms

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from tinymce import widgets as tinymce_widgets
from django.utils.translation import ugettext_lazy as _
from datetime import datetime

from myadmin.admin import MyBaseAdmin, MyBaseForm

#from website import models as modelsDbraga

from peakitcms.manager import CmsDefaultManager

from django.db.models import get_model

# AgendaEntidade
from peakitcms.agenda.entidade import models as modelsAgendaEntidade

class AgendaEntidade(modelsAgendaEntidade.getBaseAgendaEntidade()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='agendas_agendaentidades_website', default=1)
    nome = models.CharField(_(u'Nome'), max_length=255)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class AgendaEntidadeForm(MyBaseForm, modelsAgendaEntidade.getBaseAgendaEntidadeForm(AgendaEntidade)):
    pass

agendaentidade_fieldsets = modelsAgendaEntidade.getBaseAgendaEntidadeAdmin(AgendaEntidade).fieldsets
agendaentidade_fieldsets[2][1]['fields'] += (('nome',),)

class AgendaEntidadeAdmin(MyBaseAdmin, modelsAgendaEntidade.getBaseAgendaEntidadeAdmin(AgendaEntidade)):
    form = AgendaEntidadeForm
    fieldsets = agendaentidade_fieldsets
# Fim AgendaEntidade

# AgendaLocal
from peakitcms.agenda.local import models as modelsAgendaLocal

class AgendaLocal(modelsAgendaLocal.getBaseAgendaLocal()):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='agendas_agendalocals_website', default=1)
    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

class AgendaLocalForm(MyBaseForm, modelsAgendaLocal.getBaseAgendaLocalForm(AgendaLocal)):
    pass

agendalocal_fieldsets = modelsAgendaLocal.getBaseAgendaLocalAdmin(AgendaLocal).fieldsets

class AgendaLocalAdmin(MyBaseAdmin, modelsAgendaLocal.getBaseAgendaLocalAdmin(AgendaLocal)):
    form = AgendaLocalForm
    fieldsets = agendalocal_fieldsets
# Fim AgendaLocal

# Agenda
from peakitcms.agenda.agenda import models as modelsAgenda

class Agenda(modelsAgenda.getBaseAgenda(AgendaEntidade,AgendaLocal)):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='agendas_agendas_website', default=1)
    visitas_pastorais = models.BooleanField(default=False)

    objects = models.Manager()
    publicado = CmsDefaultManager()
    #pass

agenda_fildsets = modelsAgenda.getBaseAgendaAdmin(Agenda).fieldsets
agenda_fildsets[2][1]['fields'] += (('visitas_pastorais',),)

class AgendaForm(MyBaseForm, modelsAgenda.getBaseAgendaForm(Agenda)):
    pass


class AgendaAdmin(MyBaseAdmin, modelsAgenda.getBaseAgendaAdmin(Agenda)):    
    form = AgendaForm
    fieldsets = agenda_fildsets
# Fim Agenda



