# -*- coding: utf-8 *-*
#from haystack import site
from haystack import indexes
from conteudos.models import Noticia

"""
yum install jetty
"""
class NoticiaIndex(indexes.SearchIndex, indexes.Indexable):
    #, template_name='myapp/data/bio.txt'
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='titulo')
    letra = indexes.CharField(model_attr='titulo')
    date = indexes.DateTimeField(model_attr='alterado')
    website = indexes.IntegerField()

    def get_model(self):
        return Noticia

    def prepare_titulo(self, obj):
        return '%s%s%s' % (obj.titulo, obj.resumo, obj.noticia)

    def prepare_letra(self, obj):
        #print '%s' % obj.titulo[:1].upper()
        return '%sPKTINDX' % obj.titulo[:1].upper()

    def prepare_website(self, obj):
        return obj.website_id

    def index_queryset(self):
        return self.get_model().publicado

#site.register(Noticia, NoticiaIndex)
"""


"""
