from django.conf.urls.defaults import patterns, include, url
from django.views.decorators.csrf import csrf_exempt

from django.contrib import admin
from forms import GeneralSettingsForm
from djblets.siteconfig.views import site_settings
admin.autodiscover()

from .views import MyTemplateView, EtiquetaIndividual



urlpatterns = patterns('',
    (r'^admin/siteconfig/siteconfiguration/?',
        csrf_exempt(site_settings),
         {'form_class': GeneralSettingsForm},
    ),

    #(r'^grappelli/', include('grappelli.urls')),
    url(r'^admin_tools/', include('admin_tools.urls')),
    url(r'^redactor/', include('redactor.urls')),
    url(r"^ajax/photos/upload/$", "extensions.views.upload_photos", name="upload_photos"),
    url(r"^ajax/photos/recent/$", "extensions.views.recent_photos", name="recent_photos"),
    url(r"^ajax/files/upload/$", "extensions.views.upload_file", name="upload_file"),

    url(r'^elfinder/', include('elfinder.urls')),
    #url(r'^admin/conteudos/conteudo/', include('haystack.urls')),

    url(r'^admin/formularios/etiquetas_clero_envelope/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero_envelope'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_clero/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_clero_contactos/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero_contactos'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_clero_nascimento/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero_nascimento'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_clero_idade/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero_idade'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_locais_culto/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_locais_culto'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_instituicoes/?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_instituicoes'},
        name='admin-formularios-view',
    ),
    url(r'^admin/formularios/etiquetas_clero_ordenacao?$',
        MyTemplateView.as_view(template_name="admin/formularios/index.html"),
        #{'pagina':'etiquetas_clero_ordenacao'},
        name='admin-formularios-view',
    ),

    url(r'^admin/formulariospdf/?$', 'dbraga.views.MyPDFfuncetiquetas_clero'),
    #url(r'^admin/formulariospdf/?$', 'dbraga.views.MyPDFfuncetiquetas_instituicoes'),

    #url(r'^admin/formulariospdf/?$', 'dbraga.views.MyPDFfunc'),
    #url(r'^admin/formulariospdf/?$', EtiquetaIndividual.as_view(), {'id':'137'}),
    #127.0.0.1:8000/admin/formulariospdf?id=137


    url(r'^admin/', include(admin.site.urls)),
    url(r'^search/', include('haystack.urls')),
    url(r'^newsletter/', include('newsletter.urls')),
)

from django.conf.urls.static import static
from django.conf import settings


if settings.DEBUG:
    urlpatterns += static(settings.STATIC_URL,
        document_root=settings.STATIC_ROOT
    )
    urlpatterns += static(settings.MEDIA_URL,
        document_root=settings.MEDIA_ROOT
    )


urlpatterns += patterns('',
    url(r'^', include('website.urls')),
)
