#coding: utf-8


from django.views.generic import TemplateView


from diocese.models import Arciprestado #, Presbitero, DiaconoPermanente, Paroquia, Bispo, NotaHistorica, CuriaDiocesana, Secretariado





class MyTemplateView(TemplateView):

    def get_context_data(self, **kwargs):
        ctx = super(MyTemplateView, self).get_context_data(**kwargs)

        ctx['arciprestados'] = Arciprestado.objects.all().order_by('arciprestado')

        ctx['tipo_cleros'] = [
            #(None, 'Todas as Áreas'),
            ('diocese.DiaconoPermanente', 'Diáconos Permanentes'),
            ('diocese.Bispo', 'Bispos'),
            ('diocese.Presbitero', 'Presbíteros'),
            ('diocese.Diacono', 'Diáconos'),
        ]
        
        ctx['tipo_instituicaos'] = [
            #(None, 'Todas as Áreas'),            
            ('diocese.AssociacaoObraPresbitero', 'Associações e Obras para Presbíteros'),
            ('diocese.AssociacaoMovimentoObra', 'Associações Movimentos e Obras'),
            ('diocese.CentroAnimacaoEspiritual', 'Centros de Animação Espiritual'),
            ('diocese.CentroVidaCrista', 'Centros de Vida Cristã'),
            ('diocese.Chancelaria', 'Chancelaria/secretaria geral'),
            ('diocese.ColegioArciprestes', 'Colégio de Arciprestes'),
            ('diocese.ColegioConsultores', 'Colégio de Consultores'),
            ('diocese.Comissao', 'Comissões'),
            ('diocese.ComunicacaoSocial', 'Comunicações Sociais'),
            ('diocese.ConselhoPastoral', 'Conselho Pastoral'),
            ('diocese.ConselhoPresbiteral', 'Conselho Presbiteral'),
            ('diocese.CuriaDiocesana', 'Cúria Diocesana'),
            ('diocese.DiaconadoPermanente', 'Diaconado Permanente'),
            ('diocese.EscolaCatolica', 'Escolas Católicas'),
            ('diocese.FormacaoAgentePastoral', 'Formação de Agentes de Pastoral'),
            ('diocese.GestaoRecursos', 'Gestão de recursos pessoais, patrimoniais e financeiros'),
            ('diocese.InstituicaoCultural', 'Instituições Culturais'),
            ('diocese.InstitutoReligiosoFeminino', 'Institutos Religiosos Femininos'),
            ('diocese.InstitutoReligiosoMasculino', 'Institutos Religiosos Masculinos'),
            ('diocese.InstitutoSecular', 'Institutos Seculares'),
            ('diocese.ObraAccaoSocioCaritativa', 'Obras de Acção Sócio Caritativa'),
            ('diocese.PrelaturaPessoal', 'Prelaturas pessoais'),
            ('diocese.Secretariado', 'Secretariados/serviços/departamentos'),
            ('diocese.Seminario', 'Seminários'),
            ('diocese.TribunalEclesiastico', 'Tribunais Eclesiástico'),
            ('diocese.OutraInstituicao', 'Outras Instituições'),         
        ]

        ctx['ano_ordenacaos'] = [
            ('1','1'),
            ('25','25'),
            ('50','50'),
            ('60','60'),
            ('61','+60'),
        ] 

        #ctx['pagina'] = kwargs['pagina']
        ctx['pagina'] = self.request.path.replace('admin/formularios/', '').replace('/', '')

        return ctx


    def get(self, request, **kwargs):
        return super(MyTemplateView, self).get(request, **kwargs)










###################################
###################################
###################################






#coding: utf8 
#from entidades.models import Entidade
from django.contrib.admin.views.decorators import staff_member_required
#from funcoes import pdf2,pdf3,emailboletim
from django.db.models import Count

from django.views.generic.base import View
from django.conf import settings as django_settings
from django.http import Http404, HttpResponse

from reportlab.platypus.paragraph import Paragraph
from reportlab.platypus.flowables import Spacer
#from reportlab.platypus.k import KeepTogether
from reportlab.platypus.frames import Frame
from reportlab.platypus.tables import Table
from reportlab.lib.pagesizes import cm
from reportlab.lib.units import mm
from reportlab.lib import colors
from decimal import Decimal


try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO
from reportlab.pdfgen import canvas
from django.http import HttpResponse
from reportlab.lib.pagesizes import A4
from reportlab.lib.units import mm


from django.utils.translation import ugettext_lazy as _

from diocese.models import Presbitero, PRESBITERO_PRESBITERO_TIPOS_CHOICES

from relatorios.MyPDF import MyPDF


#def pdf1(request,queryset):
def MyPDFfunc1(request):
    queryset = Presbitero.objects.all()

    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=etiquetasa4.pdf'

    buffer = StringIO()

    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)

    #Define o ponto 0,0 da folha
    x = 0
    y = 3
    cnt = 0;

    #comeca a escrever
    for entidade in queryset:
        designacao = ""
        if entidade.tipo_clero!=None:
            designacao = unicode(dict(PRESBITERO_PRESBITERO_TIPOS_CHOICES)[entidade.tipo_clero])#entidade.tipo_clero
        p.drawString(x*mm,y*mm, designacao)
        """
        num_exemplares = '0'

        if entidade.num_exemplares!=None:
            num_exemplares = entidade.num_exemplares
        if num_exemplares!='0':
            num_exemplares = str(num_exemplares) + ','
        """
        num_exemplares = '[' + str(entidade.id) + ']'
        p.drawString((x+67)*mm-40, y*mm, str(num_exemplares))
        
        p.drawString(x*mm,y*mm+13, entidade.nome)

        morada = ""
        if entidade.morada!=None:
            morada = entidade.morada
        p.drawString(x*mm,y*mm+26, morada)
        
        postal = ""
        if entidade.codigo_postal!=None:
            postal = entidade.codigo_postal
        
        if entidade.localidade!=None:
            if postal!="":
                postal = postal + " "
            
            postal = postal + entidade.localidade.upper()
        
        p.drawString(x*mm,y*mm+39, postal)
        
        """
        pais = ""
        if entidade.pais!=None:
            pais = entidade.pais.upper()
        p.drawString(x*mm,y*mm+52,pais)
        """
        
        if x==140:
            x = -70
            y = y + 37
        x = x+70
        cnt = cnt+1
        if cnt == 24:
            y=3
            x=0
            cnt =0
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)
    # Close the PDF object cleanly.
    p.save()

    # Get the value of the StringIO buffer and write it to the response.
    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    return response








#def pdf2(request,entidade):
def MyPDFfunc2(request):

    entidade = Presbitero.objects.get(pk=137)

    response = HttpResponse(mimetype='application/pdf')
    ficheiro = "attachment; filename=etiqueta_individual_"+str(entidade.id)+".pdf"
    response['Content-Disposition'] = ficheiro

    buffer = StringIO()

    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)

    #Define o ponto 0,0 da folha
    x = 0
    y = 3
    #comeca a escrever
    designacao = ""
    if entidade.tipo_clero!=None:
        designacao = unicode(dict(PRESBITERO_PRESBITERO_TIPOS_CHOICES)[entidade.tipo_clero])#entidade.designacao
    p.drawString(x*mm,y*mm, designacao)
    """
    num_exemplares = '0'
    if entidade.num_exemplares!=None:
        num_exemplares = entidade.num_exemplares
    if num_exemplares!='0':
        num_exemplares = str(num_exemplares) + ','
    """
    num_exemplares = '[' + str(entidade.id) + ']'
    p.drawString((x+67)*mm-40, y*mm, str(num_exemplares))

    p.drawString(x*mm,y*mm+13, entidade.nome)

    morada = ""
    if entidade.morada!=None:
        morada = entidade.morada
    p.drawString(x*mm,y*mm+26, morada)

    postal = ""
    if entidade.codigo_postal!=None:
        postal = entidade.codigo_postal
    
    if entidade.localidade!=None:
        if postal!="":
            postal = postal + " "
        postal = postal + entidade.localidade.upper()
    
    p.drawString(x*mm,y*mm+39, postal)
    """
    pais = ""
    if entidade.pais!=None:
        pais = entidade.pais.upper()
    p.drawString(x*mm,y*mm+52,pais)
    """
    p.showPage()
    p.save()

    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    
    return response




#Nº de entidades / 1 boletim
#def pdf3(request,entidades):
def MyPDFfunc3(request):
    #from entidades.models import TarifasCorreio


    entidades = Presbitero.objects.all()

    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=somefilename.pdf'
    
    buffer = StringIO()
    
    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)
    
    #Define o ponto 0,0 da folha
    x = 0
    y = 3
    linha = 5
    #comeca a escrever
    p.drawString(x*mm, y*mm, "Tarifa de Correio")
    p.drawString((x+70)*mm,y*mm, "Nº de Entidades")
    p.line((x+68)*mm,0,(x+68)*mm,y*mm)
    y=y+linha
    for entidade in entidades:
        p.line((x+68)*mm,(y-linha)*mm,(x+68)*mm,y*mm)
        p.line(x*mm,(y-3)*mm,(x+140)*mm,(y-3)*mm)
        ###tc = TarifasCorreio.objects.get(pk=entidade['tarifa_correio'])
        ###p.drawString(x*mm, y*mm, tc.descricao)
        ###p.drawString((x+70)*mm, y*mm, str(entidade['tarifa_correio__count']))
        y=y+linha
        if y>=290:
            y=3
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)

    p.showPage()
    p.save()

    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    
    return response



#def pdf4(request):
def MyPDFfunc4(request):

    #from entidades.models import LinguaBoletim,Entidade
    #from django.db.models import Sum

    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=somefilename.pdf'
    
    buffer = StringIO()
    
    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)
    
    #Define o ponto 0,0 da folha
    x = 0
    y = 3
    linha = 5
    #comeca a escrever
    p.drawString(x*mm, y*mm, "Idioma")
    p.drawString((x+70)*mm, y*mm, "Nº exemplares")
    p.line((x+68)*mm,0,(x+68)*mm,y*mm)
    linguas = []
    ###linguas = LinguaBoletim.objects.order_by('descricao')
    y += linha
    for lingua in linguas:
        x = 0
        entidade = Entidade.objects.filter(lingua_boletim=lingua.pk).aggregate(Sum('num_exemplares'))
        if entidade['num_exemplares__sum']==None:
            entidade['num_exemplares__sum'] = 0
        p.line((x+68)*mm,(y-linha)*mm,(x+68)*mm,y*mm)
        p.line(x*mm,(y-3)*mm,(x+140)*mm,(y-3)*mm)
        p.drawString((x+3)*mm, y*mm, lingua.descricao)
        p.drawString((x+73)*mm,y*mm,str(entidade['num_exemplares__sum']))
        y += linha      
        if y>=290:
            y=3
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)

    p.showPage()
    p.save()

    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)

    return response





class EtiquetasA4(object):
    #reduzir letra
    def __init__(self, request, queryset):
        return self.run(request, queryset)
    
    def post(self):
        #response = HttpResponse(self.pdf.getToResponse(), mimetype='application/pdf')
        response = HttpResponse(self.pdf.getToResponse(), mimetype='application/pdf')
        response['Content-Disposition'] = 'attachment; filename=%s' % 'etiqueta_a4.pdf'
        return response
    
    def get_entidade(self, entidade):
        estilos = self.pdf.getStyleSeet()
        estilo_tabela = [
                           ('VALIGN',(0,0),(-1,-1),'TOP'),
                           #('BACKGROUND', (0, 0), (-1, -1), colors.orange),
                           ('TOPPADDING', (0, 0), (-1, -1), 0),
                           ('LEFTPADDING', (0, 0), (-1, -1), 0),
                           ('RIGHTPADDING', (0, 0), (-1, -1), 0),
                           ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                           ('LEADING', (0, 0), (-1, -1), 0),
                           ]
        data = []
        etiqueta = []
        if entidade.nome!=None:
            etiqueta.append(Paragraph("%s%s" % ('' if entidade.tipo_clero is None else unicode(dict(PRESBITERO_PRESBITERO_TIPOS_CHOICES)[entidade.tipo_clero])+" ", entidade.nome), estilos['EtiquetasRoman24']))
        if entidade.morada!=None:
            etiqueta.append(Paragraph("%s" % entidade.morada.replace('\n','<br/>'), estilos['EtiquetasRoman24']))
        if entidade.codigo_postal!=None:
            etiqueta.append(Paragraph("%s" % entidade.codigo_postal, estilos['EtiquetasRoman24']))
        teste = []
        ###teste.append([Paragraph('%s' % '' if entidade.pais is None or entidade.pais.upper()=='PORTUGAL' else entidade.pais.upper(), estilos['EtiquetasRomanPAIS']), Paragraph("[%s]" % str(entidade.id), estilos['EtiquetasRomanRight'])])
        teste.append([Paragraph('%s' % 'PORTUGAL', estilos['EtiquetasRomanPAIS']), Paragraph("[%s]" % str(entidade.id), estilos['EtiquetasRomanRight'])])
        
        data.append([etiqueta])
        
        t_temp = Table(teste, style=estilo_tabela)
        
        t_temp._argW[1]=2*mm
        data.append([t_temp])
        t1 = Table(data, style=[
                               #('VALIGN',(0,0),(-1,-1),'TOP'),
                               #('BACKGROUND', (0, 0), (-1, -1), colors.orange),
                               ('TOPPADDING', (0, 0), (-1, -1), 0),
                               ('LEADING', (0, 0), (-1, -1), 0),
                               ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                               ])
        
        t = Table([[t1]], style=[
                               ('VALIGN',(0,0),(-1,-1),'CENTER'),
                               #('BACKGROUND', (0, 0), (-1, -1), colors.orange),
                               ('TOPPADDING', (0, 0), (-1, -1), 0),
                               ('LEADING', (0, 0), (-1, -1), 0),
                               ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                               ])
        
        t._argW[0]=70*mm
        t._argH[0]=37*mm
        
        return t
    
    def run(self, request, queryset):
        margem = -6
        self.pdf = MyPDF(django_settings.MEDIA_ROOT+'etiqueta_a4.pdf', leftMargin=0+margem, topMargin=0+margem, bottomMargin=0+margem, rightMargin=0+margem, showBoundary=True)
        
        ###queryset = queryset.order_by('pais','cod_postal')
        num_registos=len(queryset)
        linhas = Decimal(num_registos) / 3

        #Calcula o número de linhas a apresentar
        if '.' in str(linhas):
            linhas = int(str(linhas).split('.')[0])+1
        
        l=1
        ent=0
        linha=[]
        while l<=linhas:
            c=1
            coluna=[]
            while c<=3:
                if ent<num_registos:
                    coluna.append(self.get_entidade(queryset[ent]))
                    ent+=1
                else:
                    coluna.append(Spacer(1,1))
                c+=1
            #print coluna
            t = Table([coluna], style=[
                           ('TOPPADDING', (0, 0), (-1, -1), 0),
                           ('LEFTPADDING', (0, 0), (-1, -1), 0),
                           ('RIGHTPADDING', (0, 0), (-1, -1), 0),
                           ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                           ('LEADING', (0, 0), (-1, -1), 0),
                           ])
            self.pdf.add(t)
            
            l+=1
        self.pdf.build()
        return



class EtiquetaIndividual(View):
    
    def dispatch(self, request, *args, **kwargs):
        return self.run(request, *args, **kwargs)
    
    def get(self, request, *args, **kwargs):
        
        response = HttpResponse(self.pdf.getToResponse(), mimetype='application/pdf')
        response['Content-Disposition'] = 'attachment; filename=%s' % 'individual_'+kwargs['id']+'.pdf'
        return response
    
    def run(self, request, *args, **kwargs):
        ###from entidades import models as MODELSentidades
        ###entidade = MODELSentidades.Entidade.objects.get(pk=kwargs['id'])
        entidade = Presbitero.objects.get(pk=kwargs['id'])

        margem = 0
        self.pdf = MyPDF(django_settings.MEDIA_ROOT+'individual_'+kwargs['id']+'.pdf', leftMargin=0+margem, topMargin=3+margem, bottomMargin=3+margem, rightMargin=0+margem, pagesize=(62*mm,29*mm), showBoundary=True)
        estilos = self.pdf.getStyleSeet()
        estilo_tabela = [
                           ('VALIGN',(0,0),(-1,-1),'TOP'),
                           #('BACKGROUND', (0, 0), (-1, -1), colors.orange),
                           ('TOPPADDING', (0, 0), (-1, -1), 0),
                           ('LEFTPADDING', (0, 0), (-1, -1), 0),
                           ('RIGHTPADDING', (0, 0), (-1, -1), 0),
                           ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                           ('LEADING', (0, 0), (-1, -1), 0),
                           ]
        data = []
        etiqueta = []
        if entidade.nome!=None:
            etiqueta.append(Paragraph("%s%s" % ('' if entidade.tipo_clero is None else unicode(dict(PRESBITERO_PRESBITERO_TIPOS_CHOICES)[entidade.tipo_clero])+" ", entidade.nome), estilos['EtiquetasRoman']))
        if entidade.morada!=None:
            etiqueta.append(Paragraph("%s" % entidade.morada.replace('\n','<br/>'), estilos['EtiquetasRoman']))
        if entidade.codigo_postal!=None:
            etiqueta.append(Paragraph("%s" % entidade.codigo_postal, estilos['EtiquetasRoman']))
        teste = []
        ###teste.append([Paragraph('%s' % '' if entidade.pais is None or entidade.pais.upper()=='PORTUGAL' else entidade.pais.upper(), estilos['EtiquetasRomanPAIS']), Paragraph("[%s]" % str(entidade.id), estilos['EtiquetasRomanRight'])])
        teste.append([Paragraph('%s' % 'PORTUGAL', estilos['EtiquetasRomanPAIS']), Paragraph("[%s]" % str(entidade.id), estilos['EtiquetasRomanRight'])])
        
        
        data.append(
                    [
                     etiqueta
                     
                     ]
                    )
        
        #data = etiqueta
        t_temp = Table(teste, style=estilo_tabela)
        t_temp._argW[1]=1*mm
        data.append([t_temp])
        """
        ,
                     Spacer(10,10)
        """
        t1 = Table(data, style=[
                               ('TOPPADDING', (0, 0), (-1, -1), 0),
                               ('LEADING', (0, 0), (-1, -1), 0),
                               ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                               ])
        
        t = Table([[t1]], style=[
                               ('VALIGN',(0,0),(-1,-1),'CENTER'),
                               #('BACKGROUND', (0, 0), (-1, -1), colors.orange),
                               ('TOPPADDING', (0, 0), (-1, -1), 0),
                               ('LEADING', (0, 0), (-1, -1), 0),
                               ('BOTTOMPADDING', (0, 0), (-1, -1), 0),
                               ('LEFTPADDING', (0, 0), (-1, -1), 0),
                               ('RIGHTPADDING', (0, 0), (-1, -1), 0),
                               ])
        
        t._argW[0]=62*mm
        t._argH[0]=22*mm
        #t._argW[0]=62*mm
        #t._argH[0]=28.96*mm
        self.pdf.add(t)
        #for d in data:
        #    self.pdf.add(d)
        self.pdf.build()
        
        return super(EtiquetaIndividual, self).dispatch(request, *args, **kwargs)

"""
def etiquetaindividual(request,id):
        e = Entidade.objects.get(pk=id)
    return pdf2(request,e)
"""

def numentidades1boletim(request):
    e = Entidade.objects.filter(num_exemplares=1).values('tarifa_correio').order_by().annotate(Count('tarifa_correio'))
    return pdf3(request,e)
"""
def totalboletim(request):
    return pdf4(request)
"""
def boletimemail(request):
#   e = Entidade.objects.filter(tipo_correio='E').exclude(email='')
    return emailboletim(request)

#etiquetaa4 = staff_member_required(etiquetaindividual)




def MyPDFfunca(request):
    #e = queryset.order_by('pais','cod_postal')
    queryset = Presbitero.objects.all()
    e = EtiquetasA4(request, queryset)
    #return pdf1(request,e)
    return e.post()



def MyPDFfuncb(request):
    return EtiquetaIndividual.as_view()





from django.contrib.auth.decorators import login_required
@login_required(login_url='/admin')

def MyPDFfunc(request):
    #print request

    if 'etiquetas_clero_envelope' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero_envelope(request)
    elif 'etiquetas_clero' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero(request)
    elif 'etiquetas_clero_contactos' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero_contactos(request)
    elif 'etiquetas_clero_nascimento' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero_nascimento(request)
    elif 'etiquetas_clero_idade' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero_idade(request)
    elif 'etiquetas_clero_ordenacao' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_clero_ordenacao(request)
    elif 'etiquetas_locais_culto' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_locais_culto(request)
    elif 'etiquetas_instituicoes' in request.META['HTTP_REFERER']:
        return MyPDFfuncetiquetas_instituicoes(request)

    return None





#from reportlab.lib.pagesizes import A3
from diocese.models import Paroquia
from django.db import models
from haystack.query import SearchQuerySet


#def pdf1(request,queryset):
def MyPDFfuncetiquetas_locais_culto(request):

    queryset = Paroquia.objects.all()

    if request.POST['arciprestado']:
        queryset = queryset.filter(arciprestado = request.POST['arciprestado'])
    if request.POST['nome']:    
        queryset = queryset.filter(nome__icontains = request.POST['nome'])

    #queryset = queryset.order_by('nome')

    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=etiquetas_locais_culto.pdf'

    buffer = StringIO()

    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)

    #Define o ponto 0,0 da folha
    x = 0
    y = 0
    cnt = 0
    
    #comeca a escrever
    for entidade in queryset:
        xmm = 21
        ymm = 17

        ymm += 13
        morada = ""
        if entidade.morada!=None:
            if u'Paróquia' in entidade.morada:
                p.drawString(x*mm+xmm,y*mm+ymm, entidade.morada.split(',')[0])
                morada = ','.join(entidade.morada.split(',')[1:])
                if len(morada) > 1:
                    if morada[0] == ' ':
                        morada = morada[1:]
            else:                
                #morada = entidade.morada.replace(u'Paróquia '+entidade.nome+',','')
                morada = entidade.morada
                p.drawString(x*mm+xmm,y*mm+ymm, u'Paróquia '+entidade.nome)

        if morada:
            mymorada = []
            for m in morada.split(','): 

                if len(m) > 1:
                    mym = m.strip()

                    try:
                        if (mym.isdigit() or 's/n' in mym.lower() or u'nº' in mym.lower() or 'C. P.' in mym.lower() or 'Ap.' in mym.lower()) and len(mym)<13:
                            mymorada[len(mymorada)-1] += ', '+ mym
                        else:
                            mymorada += [mym]
                    except Exception, e:
                        print e
                        mymorada += [mym]

            for newmorada in mymorada:
                ymm += 13
                p.drawString(x*mm+xmm,y*mm+ymm, newmorada)

        ymm += 13
        postal = ""
        if entidade.codigo_postal!=None:
            postal = entidade.codigo_postal
        
        if entidade.localidade!=None:
            if postal!="":
                postal = postal + " "
            
            postal = postal + entidade.localidade.upper()
        
        p.drawString(x*mm+xmm,y*mm+ymm, postal)
                
        if x==100:
            x = -100
            y = y + 37
        x = x+100
        cnt = cnt+1
        if cnt == 16:
            y=0
            x=0
            cnt =0
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)
    
    # Close the PDF object cleanly.
    p.save()

    # Get the value of the StringIO buffer and write it to the response.
    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    return response




def MyPDFfuncetiquetas_instituicoes(request):
    #queryset = Paroquia.objects.all()

    queryset = SearchQuerySet().all()

    search_models = []
    if request.POST['tipo_instituicao']:
        search_models.append(models.get_model(*request.POST['tipo_instituicao'].split('.')))
        queryset = queryset.models(*search_models)#.order_by('-date')
    else:        
        nonemodels = 'diocese.AssociacaoObraPresbitero,diocese.AssociacaoMovimentoObra,diocese.CentroAnimacaoEspiritual,diocese.CentroVidaCrista,diocese.Chancelaria,diocese.ColegioArciprestes,diocese.ColegioConsultores,diocese.Comissao,diocese.ComunicacaoSocial,diocese.ConselhoPastoral,diocese.ConselhoPresbiteral,diocese.CuriaDiocesana,diocese.DiaconadoPermanente,diocese.EscolaCatolica,diocese.FormacaoAgentePastoral,diocese.GestaoRecursos,diocese.InstituicaoCultural,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,diocese.ObraAccaoSocioCaritativa,diocese.PrelaturaPessoal,diocese.Secretariado,diocese.Seminario,diocese.TribunalEclesiastico,diocese.OutraInstituicao'
        
        for model in nonemodels.split(','):
            search_models.append(models.get_model(*model.split('.')))

        queryset = queryset.models(*search_models)#.order_by('-date')
    
    if request.POST['arciprestado']:
        queryset = queryset.filter(arciprestado = request.POST['arciprestado'])
    if request.POST['nome']:    
        queryset = queryset.filter(text = request.POST['nome'])


    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=etiquetas_instituicoes.pdf'

    buffer = StringIO()

    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)

    #Define o ponto 0,0 da folha
    x = 0
    y = 0
    cnt = 0
    
    #comeca a escrever
    for entidade in queryset:
        entidade = entidade.object
        xmm = 21
        ymm = 17

        ymm += 13
        p.drawString(x*mm+xmm,y*mm+ymm, entidade.nome)

        morada = ""
        if entidade.morada!=None:
            morada = entidade.morada
            mymorada = []
            for m in morada.split(','): 

                if len(m) > 1:
                    mym = m.strip()

                    try:
                        if (mym.isdigit() or 's/n' in mym.lower() or u'nº' in mym.lower() or 'C. P.' in mym.lower() or 'Ap.' in mym.lower() or len(mym)<5) and len(mym)<13:
                            mymorada[len(mymorada)-1] += ', '+ mym
                        else:
                            mymorada += [mym]
                    except Exception, e:
                        print e
                        mymorada += [mym]

            for newmorada in mymorada:
                ymm += 13
                p.drawString(x*mm+xmm,y*mm+ymm, newmorada)

        ymm += 13
        postal = ""
        if entidade.codigo_postal!=None:
            postal = entidade.codigo_postal
        
        if entidade.localidade!=None:
            if postal!="":
                postal = postal + " "
            
            postal = postal + entidade.localidade.upper()
        
        p.drawString(x*mm+xmm,y*mm+ymm, postal)
                
        if x==100:
            x = -100
            y = y + 37
        x = x+100
        cnt = cnt+1
        if cnt == 16:
            y=0
            x=0
            cnt =0
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)
    
    # Close the PDF object cleanly.
    p.save()

    # Get the value of the StringIO buffer and write it to the response.
    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    return response









def MyPDFfuncetiquetas_clero(request):
    #queryset = SearchQuerySet().all()
    #queryset = SearchQuerySet().filter(faleceu=False)
    queryset = SearchQuerySet().all()
    #queryset2 = SearchQuerySet().filter(faleceu=False)

    #print request.POST

    search_models = []
    if request.POST['tipo_clero']:
        search_models.append(models.get_model(*request.POST['tipo_clero'].split('.')))
        queryset = queryset.models(*search_models)#.order_by('-date')
    else:        
        nonemodels = 'diocese.DiaconoPermanente,diocese.Bispo,diocese.Presbitero,diocese.Diacono'
        nonemodels = 'diocese.Presbitero'
        
        for model in nonemodels.split(','):
            search_models.append(models.get_model(*model.split('.')))

        queryset = queryset.models(*search_models)#.order_by('-date')

    print queryset

    if request.POST['arciprestado']:
    #    queryset = queryset.filter(arciprestado = request.POST['arciprestado'])
        queryset = queryset.filter(dioceses_presbiteroarciprestados_presbiteroarciprestados_presbitero__arciprestado__pk = request.POST['arciprestado'])
    if request.POST['nome']:    
        queryset = queryset.filter(text = request.POST['nome'])
    
    print queryset

    response = HttpResponse(mimetype='application/pdf')
    response['Content-Disposition'] = 'attachment; filename=etiquetas_clero.pdf'

    buffer = StringIO()

    p = canvas.Canvas(buffer,pagesize=A4,bottomup=0)
    p.translate(mm,mm)
    p.setFont("Times-Roman", 10)

    #Define o ponto 0,0 da folha
    x = 0
    y = 0
    cnt = 0
    
    #comeca a escrever
    for entidade in queryset:
        entidade = entidade.object
        xmm = 21
        ymm = 17

        ymm += 13
        p.drawString(x*mm+xmm,y*mm+ymm, u'Rev.do Senhor')

        titulo=''
        """
        if entidade._meta.db_table == 'diocese_bispo':
            titulo = u'Dom '
        elif entidade._meta.db_table == 'diocese_diacono':
            titulo = u'Diácono '
        elif entidade._meta.db_table == 'diocese_presbitero':
            if entidade.tipo_clero == 1:
                titulo = u'Padre '
            elif entidade.tipo_clero == 2:
                titulo = u'Monsenhor '
            elif entidade.tipo_clero == 3:
                titulo = u'Cónego '
            elif entidade.tipo_clero == 4:
                titulo = u'Mon. Cónego '
        elif entidade._meta.db_table == 'diocese_diaconopermanente':
            titulo = u'Diác. Permanente '
        """
        ymm += 13
        p.drawString(x*mm+xmm,y*mm+ymm, titulo +entidade.nome)

        morada = ""
        if entidade.morada!=None:
            morada = entidade.morada
            mymorada = []
            for m in morada.split(','): 

                if len(m) > 1:
                    mym = m.strip()

                    try:
                        if (mym.isdigit() or 's/n' in mym.lower() or u'nº' in mym.lower() or 'C. P.' in mym.lower() or 'Ap.' in mym.lower() or len(mym)<5) and len(mym)<13:
                            mymorada[len(mymorada)-1] += ', '+ mym
                        else:
                            mymorada += [mym]
                    except Exception, e:
                        print e
                        mymorada += [mym]

            for newmorada in mymorada:
                ymm += 13
                p.drawString(x*mm+xmm,y*mm+ymm, newmorada)

        ymm += 13
        postal = ""
        if entidade.codigo_postal!=None:
            postal = entidade.codigo_postal
        
        if entidade.localidade!=None:
            if postal!="":
                postal = postal + " "
            
            postal = postal + entidade.localidade.upper()
        
        p.drawString(x*mm+xmm,y*mm+ymm, postal)
                
        if x==100:
            x = -100
            y = y + 37
        x = x+100
        cnt = cnt+1
        if cnt == 16:
            y=0
            x=0
            cnt =0
            p.showPage()
            p.translate(mm,mm)
            p.setFont("Times-Roman",10)
    
    # Close the PDF object cleanly.
    p.save()

    # Get the value of the StringIO buffer and write it to the response.
    pdf = buffer.getvalue()
    buffer.close()
    response.write(pdf)
    return response






