# -*- coding: utf-8 *-*
#from haystack import site
from haystack import indexes
from diocese.models import DiaconoPermanente, Presbitero, Bispo, Diacono, Seminario, InstitutoReligiosoFeminino, InstitutoReligiosoMasculino, InstitutoSecular, CuriaDiocesana, AssociacaoObraPresbitero, AssociacaoMovimentoObra, CentroAnimacaoEspiritual, CentroVidaCrista, Chancelaria, ColegioArciprestes, ColegioConsultores, Comissao, ComunicacaoSocial, ConselhoPastoral, ConselhoPresbiteral, DiaconadoPermanente, EscolaCatolica, FormacaoAgentePastoral, GestaoRecursos, InstituicaoCultural, ObraAccaoSocioCaritativa, PrelaturaPessoal, Secretariado, TribunalEclesiastico, OutraInstituicao

from datetime import date


"""
yum install jetty
"""

"""
    Clero
"""
class DiaconoPermanenteIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    #arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    faleceu = indexes.BooleanField(model_attr='faleceu')
    website = indexes.IntegerField()
    idade = indexes.IntegerField()

    def get_model(self):
        return DiaconoPermanente

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    #def prepare_arciprestado(self, obj):
    #    return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def prepare_faleceu(self, obj):
        return obj.faleceu

    def prepare_idade(self, obj):
        if obj.data_nascimento:
            d = date.today()
            return (d.year - obj.data_nascimento.year) - int((d.month, d.day) < (obj.data_nascimento.month, obj.data_nascimento.day))
        else:
            return ''

    def index_queryset(self):
        return self.get_model().objects

class PresbiteroIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    #arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()
    
    def get_model(self):
        return Presbitero

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    #def prepare_arciprestado(self, obj):
    #    return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects.filter(faleceu=False)



class BispoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    #arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()
    idade = indexes.IntegerField()

    def get_model(self):
        return Bispo

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    #def prepare_arciprestado(self, obj):
    #    return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def prepare_idade(self, obj):
        if obj.data_nascimento:
            d = date.today()
            return (d.year - obj.data_nascimento.year) - int((d.month, d.day) < (obj.data_nascimento.month, obj.data_nascimento.day))
        else:
            return ''

    def index_queryset(self):
        return self.get_model().objects.filter(faleceu=False)

"""
    Comunidade e vida religiosa
"""
class SeminarioIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()
    
    def get_model(self):
        return Seminario

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects
        
class InstitutoReligiosoMasculinoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return InstitutoReligiosoMasculino

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects

class InstitutoReligiosoFemininoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return InstitutoReligiosoFeminino

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects

class InstitutoSecularIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return InstitutoSecular

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects


"""
    Curia
"""
class CuriaDiocesanaIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return CuriaDiocesana

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





"""
"""


class DiaconoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    #arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()
    idade = indexes.IntegerField()

    def get_model(self):
        return Diacono

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    #def prepare_arciprestado(self, obj):
    #    return obj.dioceses_diaconoarciprestados_diaconoarciprestados_diacono.all()

    def prepare_website(self, obj):
        return 1

    def prepare_idade(self, obj):
        if obj.data_nascimento:
            d = date.today()
            return (d.year - obj.data_nascimento.year) - int((d.month, d.day) < (obj.data_nascimento.month, obj.data_nascimento.day))
        else:
            return ''

    def index_queryset(self):
        return self.get_model().objects.filter(faleceu=False)



class AssociacaoObraPresbiteroIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return AssociacaoObraPresbitero

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects



class AssociacaoMovimentoObraIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return AssociacaoMovimentoObra

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class CentroAnimacaoEspiritualIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return CentroAnimacaoEspiritual

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects



class CentroVidaCristaIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return CentroVidaCrista

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects



class ChancelariaIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return Chancelaria

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class ColegioArciprestesIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ColegioArciprestes

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class ColegioConsultoresIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ColegioConsultores

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class ComissaoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return Comissao

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class ComunicacaoSocialIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ComunicacaoSocial

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class ConselhoPastoralIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ConselhoPastoral

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects






class ConselhoPresbiteralIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ConselhoPresbiteral

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects






class DiaconadoPermanenteIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    #arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return DiaconadoPermanente

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    #def prepare_arciprestado(self, obj):
    #    return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class EscolaCatolicaIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return EscolaCatolica

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects






class FormacaoAgentePastoralIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return FormacaoAgentePastoral

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class GestaoRecursosIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return GestaoRecursos

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class InstituicaoCulturalIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return InstituicaoCultural

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects





class ObraAccaoSocioCaritativaIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return ObraAccaoSocioCaritativa

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class PrelaturaPessoalIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return PrelaturaPessoal

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class SecretariadoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return Secretariado

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class TribunalEclesiasticoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return TribunalEclesiastico

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects




class OutraInstituicaoIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)
    titulo = indexes.EdgeNgramField(model_attr='nome')
    letra = indexes.CharField(model_attr='nome')
    date = indexes.DateTimeField(model_attr='alterado')
    arciprestado = indexes.CharField(model_attr='arciprestado', null=True)
    website = indexes.IntegerField()

    def get_model(self):
        return OutraInstituicao

    def prepare_letra(self, obj):
        return '%sPKTINDX' % obj.nome[:1].upper()

    def prepare_arciprestado(self, obj):
        return obj.arciprestado

    def prepare_website(self, obj):
        return 1

    def index_queryset(self):
        return self.get_model().objects



