#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseArciprestado(basepresbitero):
    class BaseArciprestado(SharedBase):
        arciprestado = models.CharField(_(u'Arciprestado'), max_length=255)
        arcipreste = models.CharField(_(u'Arcipreste'), max_length=255, null=True, blank=True)
        arcipreste_adjunto = models.CharField(_(u'Arcipreste Adjunto'), max_length=255, null=True, blank=True)
        presbitero_arcipreste = models.ForeignKey(basepresbitero, verbose_name=_(u'Arcipreste'), related_name='%(app_label)s_%(class)s_presbitero_arcipreste', null=True, blank=True)
        presbitero_arcipreste_adjunto = models.ForeignKey(basepresbitero, verbose_name=_(u'Arcipreste Adjunto'), related_name='%(app_label)s_%(class)s_presbitero_arcipreste_adjunto', null=True, blank=True)

        class Meta:
            verbose_name = _(u'Vigararia/Arciprestado')
            verbose_name_plural = _(u'Vigararias/Arciprestados')
            abstract = True
            ordering = ['arciprestado']

        def __unicode__(self):
            return self.arciprestado
    return BaseArciprestado
# Fim Models

# Admin
def getBaseArciprestadoForm(mymodel):
    class BaseArciprestadoForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseArciprestadoForm

def getBaseArciprestadoAdmin(mymodel):
    class BaseArciprestadoAdmin(getBaseAdmin(mymodel)):
        form = getBaseArciprestadoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('arciprestado',),
                                       ('arcipreste',),
                                       ('arcipreste_adjunto',),
                                       )
                             }),
                     )
        list_display = ('arciprestado', 'alterado', 'id',)
        search_fields = ('arciprestado', 'id', )

    return BaseArciprestadoAdmin
# Fim Admin
