#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseAssociacaoObraPresbitero():
    class BaseAssociacaoObraPresbitero(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        director = models.TextField(_(u'Director/Direcção'), null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Associação e Obra para Presbíteros')
            verbose_name_plural = _(u'Associações e Obras para Presbíteros')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseAssociacaoObraPresbitero
# Fim Models

# Admin
def getBaseAssociacaoObraPresbiteroForm(mymodel):
    class BaseAssociacaoObraPresbiteroForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseAssociacaoObraPresbiteroForm

def getBaseAssociacaoObraPresbiteroAdmin(mymodel):
    class BaseAssociacaoObraPresbiteroAdmin(getBaseAdmin(mymodel)):
        form = getBaseAssociacaoObraPresbiteroForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('director',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseAssociacaoObraPresbiteroAdmin
# Fim Admin
