#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseBispo(TIPOS_CHOICES):
    if TIPOS_CHOICES == None:
        TIPOS_CHOICES=(
            (1, _(u'Diocesano')),
            (2, _(u'Auxiliar')),
            (3, _(u'Coadjutor')),
            (4, _(u'Emérito')),
            (6, _(u'Emérito de outra Diocese')),
        )

    class BaseBispo(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        bispo_tipo = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=TIPOS_CHOICES, default=1)
        data_nascimento = models.DateField(_(u'Data Nascimento'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        local_nascimento = models.CharField(_(u'Local Nascimento'), max_length=255, null=True, blank=True)
        data_orden_presbiteral = models.DateField(_(u'Data ordenação Presbiteral'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        local_ordenacao_presb = models.CharField(_(u'Local Ordenação presbiteral'), max_length=255, null=True, blank=True)
        data_orden_episc = models.DateField(_(u'Data Ordenação Episcopal'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        local_ordenacoa_episc = models.CharField(_(u'Local Ordenação Episcopal'), max_length=255, null=True, blank=True)
        curriculo = models.TextField(_(u'Currículo'), null=True, blank=True)
        data_nomeacao = models.DateField(_(u'Data da nomeação'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        data_tomada = models.DateField(_(u'Data da tomada de posse'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        data_resignacao = models.DateField(_(u'Data resignação'), help_text='(aaaa-mm-dd)', null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Cód. postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        observacoes = models.TextField(_(u'Observacões'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Bispo')
            verbose_name_plural = _(u'Bispos')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseBispo
# Fim Models

# Admin
def getBaseBispoForm(mymodel):
    class BaseBispoForm(forms.ModelForm):
        nome = forms.CharField(label=_(u'Nome'), max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseBispoForm

def getBaseBispoAdmin(mymodel):
    class BaseBispoAdmin(getBaseAdmin(mymodel)):
        form = getBaseBispoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome','bispo_tipo',),
                                       ('data_nascimento','local_nascimento',),
                                       ('data_orden_presbiteral','local_ordenacao_presb',),
                                       ('data_orden_episc','local_ordenacoa_episc',),
                                       ('curriculo',),
                                       ('data_nomeacao','data_tomada',),
                                       ('data_resignacao',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('observacoes',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseBispoAdmin
# Fim Admin
