#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseCabido():
    class BaseCabido(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        presidente = models.CharField(_(u'Presidente'), max_length=255, null=True, blank=True)
        vice_presidente = models.CharField(_(u'Vice-Presidente'), max_length=255, null=True, blank=True)
        secretario = models.CharField(_(u'Secretário'), max_length=255, null=True, blank=True)
        dignidades = models.TextField(_(u'Dignidades'), null=True, blank=True)
        deao = models.CharField(_(u'Deão'), max_length=255, null=True, blank=True)
        chantre = models.CharField(_(u'Chantre'), max_length=255, null=True, blank=True)
        mestre_escola = models.CharField(_(u'Mestre Escola'), max_length=255, null=True, blank=True)
        arcediago = models.CharField(_(u'Arcediago'), max_length=255, null=True, blank=True)
        tesoureiro = models.CharField(_(u'Tesoureiro'), max_length=255, null=True, blank=True)
        penitenciario = models.CharField(_(u'Penitenciario'), max_length=255, null=True, blank=True)
        capitulares = models.TextField(_(u'Capitulares'), null=True, blank=True)
        honorarios = models.TextField(_(u'Honorários'), null=True, blank=True)
        jubilados = models.TextField(_(u'Jubilados Eméritos'), null=True, blank=True)
        beneficiados = models.TextField(_(u'Beneficiados'), null=True, blank=True)
        arquivo_capitular = models.CharField(_(u'Arquivo capitular'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Cabido')
            verbose_name_plural = _(u'Cabidos')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseCabido
# Fim Models

# Admin
def getBaseCabidoForm(mymodel):
    class BaseCabidoForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Cabido da Diocese ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseCabidoForm

def getBaseCabidoAdmin(mymodel):
    class BaseCabidoAdmin(getBaseAdmin(mymodel)):
        form = getBaseCabidoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('presidente',),
                                       ('vice_presidente',),
                                       ('secretario',),
                                       ('dignidades',),
                                       ('deao',),
                                       ('chantre',),
                                       ('mestre_escola',),
                                       ('arcediago',),
                                       ('tesoureiro',),
                                       ('penitenciario',),
                                       ('capitulares',),
                                       ('honorarios',),
                                       ('jubilados',),
                                       ('beneficiados',),
                                       ('arquivo_capitular',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseCabidoAdmin
# Fim Admin
