#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseColegioConsultores():
    class BaseColegioConsultores(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        colegio_consultores = models.TextField(_(u'Colégio de Consultores'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Colégio de Consultores')
            verbose_name_plural = _(u'Colégios de Consultores')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseColegioConsultores
# Fim Models

# Admin
def getBaseColegioConsultoresForm(mymodel):
    class BaseColegioConsultoresForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Colégio de consultores de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseColegioConsultoresForm

def getBaseColegioConsultoresAdmin(mymodel):
    class BaseColegioConsultoresAdmin(getBaseAdmin(mymodel)):
        form = getBaseColegioConsultoresForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('colegio_consultores',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseColegioConsultoresAdmin
# Fim Admin
