#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseComunicacaoSocial(TIPOS_CHOICES, PERIOCIDADES_CHOICES):

    if TIPOS_CHOICES == None:
        TIPOS_CHOICES = (
            (1, _(u'Boletim')),
            (7, _(u'Editora')),
            (6, _(u'Jornal')),
            (5, _(u'Livraria')),
            (4, _(u'Rádio')),
            (3, _(u'Revista')),
            (2, _(u'Tipografia')),
        )
    if PERIOCIDADES_CHOICES == None:
        PERIOCIDADES_CHOICES = (
            (9, _(u'Anual')),
            (7, _(u'Bimensal')),
            (8, _(u'Bimestral')),
            (6, _(u'Diário')),
            (5, _(u'Mensal')),
            (4, _(u'Quadrimestral')),
            (3, _(u'Quinzenal')),
            (2, _(u'Semanal')),
            (1, _(u'Trimestral')),
        )

    class BaseComunicacaoSocial(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        tipo = models.PositiveIntegerField(_(u'Tipo'), max_length=1, choices=TIPOS_CHOICES, null=True, blank=True)
        periocidade = models.PositiveIntegerField(_(u'Periodicidade'), max_length=1, choices=PERIOCIDADES_CHOICES, null=True, blank=True)
        director = models.CharField(_(u'Director'), max_length=255, null=True, blank=True)
        propriedade = models.CharField(_(u'Propriedade'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Comunicação Social')
            verbose_name_plural = _(u'Comunicações Sociais')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseComunicacaoSocial
# Fim Models

# Admin
def getBaseComunicacaoSocialForm(mymodel):
    class BaseComunicacaoSocialForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseComunicacaoSocialForm

def getBaseComunicacaoSocialAdmin(mymodel):
    class BaseComunicacaoSocialAdmin(getBaseAdmin(mymodel)):
        form = getBaseComunicacaoSocialForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('tipo',),
                                       ('periocidade',),
                                       ('director',),
                                       ('propriedade',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseComunicacaoSocialAdmin
# Fim Admin
