#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseConselhoPresbiteral():
    class BaseConselhoPresbiteral(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        membros_natos = models.TextField(_(u'Membros Natos'), null=True, blank=True)
        associados_presidencia = models.TextField(_(u'Associados à Presidência'), null=True, blank=True)
        por_eleicao = models.TextField(_(u'Por Eleição'), null=True, blank=True)
        designados_bispo = models.TextField(_(u'Designados pelo Bispo'), null=True, blank=True)
        conselho_permanente = models.TextField(_(u'Conselho Permanente'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Conselho Presbiteral')
            verbose_name_plural = _(u'Conselhos Presbiterais')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseConselhoPresbiteral
# Fim Models

# Admin
def getBaseConselhoPresbiteralForm(mymodel):
    class BaseConselhoPresbiteralForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Conselho Presbiteral ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseConselhoPresbiteralForm

def getBaseConselhoPresbiteralAdmin(mymodel):
    class BaseConselhoPresbiteralAdmin(getBaseAdmin(mymodel)):
        form = getBaseConselhoPresbiteralForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('membros_natos',),
                                       ('associados_presidencia',),
                                       ('por_eleicao',),
                                       ('designados_bispo',),
                                       ('conselho_permanente',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseConselhoPresbiteralAdmin
# Fim Admin
