#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseConselhoPastoral():
    class BaseConselhoPastoral(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        mandato = models.CharField(_(u'Mandato'), max_length=255, null=True, blank=True)
        membros_natos = models.TextField(_(u'Membros Natos'), null=True, blank=True)
        membros_designados = models.TextField(_(u'Membros Designados'), null=True, blank=True)
        membros_eleitos = models.TextField(_(u'Membros Eleitos'), null=True, blank=True)
        comissao_permanente = models.TextField(_(u'Comissão Permanente'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Conselho Pastoral')
            verbose_name_plural = _(u'Conselhos Pastorais')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseConselhoPastoral
# Fim Models

# Admin
def getBaseConselhoPastoralForm(mymodel):
    class BaseConselhoPastoralForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Conselho Pastoral ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseConselhoPastoralForm

def getBaseConselhoPastoralAdmin(mymodel):
    class BaseConselhoPastoralAdmin(getBaseAdmin(mymodel)):
        form = getBaseConselhoPastoralForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('mandato',),
                                       ('membros_natos',),
                                       ('membros_designados',),
                                       ('membros_eleitos',),
                                       ('comissao_permanente',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseConselhoPastoralAdmin
# Fim Admin
