#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseCuriaDiocesana():
    class BaseCuriaDiocesana(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        horarios = models.CharField(_(u'Horário'), max_length=255, null=True, blank=True)
        conselho_episcopal = models.TextField(_(u'Conselho episcopal'), null=True, blank=True)
        moderador = models.CharField(_(u'Moderador'), max_length=255, null=True, blank=True)
        vigarios_gerais = models.TextField(_(u'Vigários Gerais'), null=True, blank=True)
        vigarios_gerais_ad = models.TextField(_(u'Vigarios Gerais Adjuntos'), null=True, blank=True)
        provigario_geral = models.CharField(_(u'Provigário Geral'), max_length=255, null=True, blank=True)
        direvigarios_episcopais = models.TextField(_(u'Vigários Episcopais'), null=True, blank=True)
        delegados_episcopais = models.TextField(_(u'Delegados Episcopais'), null=True, blank=True)
        secretaria_episcopal = models.CharField(_(u'Secretaria Episcopal'), max_length=255, null=True, blank=True)
        chefe_gabinete = models.CharField(_(u'Chefe de Gabinete'), max_length=255, null=True, blank=True)
        secretario_particular = models.CharField(_(u'Secretário particular'), max_length=255, null=True, blank=True)
        gabinete_informacao = models.CharField(_(u'Gabinete de Informação'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Cúria Diocesana')
            verbose_name_plural = _(u'Cúrias Diocesana')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseCuriaDiocesana
# Fim Models

# Admin
def getBaseCuriaDiocesanaForm(mymodel):
    class BaseCuriaDiocesanaForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Cúria Diocesana de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseCuriaDiocesanaForm

def getBaseCuriaDiocesanaAdmin(mymodel):
    class BaseCuriaDiocesanaAdmin(getBaseAdmin(mymodel)):
        form = getBaseCuriaDiocesanaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal', 'localidade',),
                                       ('telefone', 'telemovel',),
                                       ('fax', 'email',),
                                       ('paginaweb',),
                                       ('horarios',),
                                       ('conselho_episcopal',),
                                       ('moderador',),
                                       ('vigarios_gerais',),
                                       ('vigarios_gerais_ad',),
                                       ('provigario_geral',),
                                       ('direvigarios_episcopais',),
                                       ('delegados_episcopais',),
                                       ('secretaria_episcopal',),
                                       ('chefe_gabinete',),
                                       ('secretario_particular',),
                                       ('gabinete_informacao',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseCuriaDiocesanaAdmin
# Fim Admin
