#coding: utf-8
from django.contrib import admin
from django.db import models
from feincms.models import create_base_model
from django.utils.translation import ugettext_lazy as _

from diocesesim.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm, SharedBase

from django import forms
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from elfinder.models import FileCollection

# Models
def getBaseDadosEstatisticos():
    class BaseDadosEstatisticos(SharedBase):
        ano = models.IntegerField(_(u'ANO'), unique=True)
        superficie = models.IntegerField(_(u'Superfície (Km2)'), null=True, blank=True)
        populacao = models.IntegerField(_(u'População'), null=True, blank=True)
        catolicos = models.IntegerField(_(u'Católicos'), null=True, blank=True)
        arciprestados = models.IntegerField(_(u'Arciprestados (vigararias ou ouvidorias)'), null=True, blank=True)
        paroquias = models.IntegerField(_(u'Paróquias (ou equiparadas)'), null=True, blank=True)
        pclerodiocesano = models.IntegerField(_(u'- com pároco próprio (clero diocesano)'), null=True, blank=True)
        pcleroreligioso = models.IntegerField(_(u'- com pároco próprio (clero religioso)'), null=True, blank=True)
        poutrosacerdote = models.IntegerField(_(u'-  administradas por outro sacerdote (1)'), null=True, blank=True)
        pdiaconosper = models.IntegerField(_(u'-  confiadas a diáconos permanentes'), null=True, blank=True)
        preligiosas = models.IntegerField(_(u'-  confiadas a religiosas'), null=True, blank=True)
        pleigos = models.IntegerField(_(u'-  confiadas a leigos'), null=True, blank=True)
        totalmentevacantes = models.IntegerField(_(u'-  totalmente vacantes'), null=True, blank=True)
        capelanias = models.IntegerField(_(u'Capelanias (2)'), null=True, blank=True)
        sacerdotesdiocesanos = models.IntegerField(_(u'Sacerdotes diocesanos (incardinados)'), null=True, blank=True)
        spdiocesepropria = models.IntegerField(_(u'- em serviço pastoral na diocese própria'), null=True, blank=True)
        spnoutradiocese = models.IntegerField(_(u'- em serviço pastoral noutra diocese'), null=True, blank=True)
        foraservicopastoral = models.IntegerField(_(u'-  fora do serviço pastoral'), null=True, blank=True)
        srrdiocese = models.IntegerField(_(u'Sacerdotes religiosos residentes na diocese'), null=True, blank=True)
        srrtotalpartesdiocese = models.IntegerField(_(u'- total ou em parte ao serviço da diocese'), null=True, blank=True)
        srrservicoinstituto = models.IntegerField(_(u'- ao serviço estrito do seu instituto'), null=True, blank=True)
        srrforaservicopastoral = models.IntegerField(_(u'-  fora do serviço pastoral (3)'), null=True, blank=True)
        religiososprofessosnsacerdotes = models.IntegerField(_(u'Religiosos professos não sacerdotes (4)'), null=True, blank=True)
        religiosasprofessasrd = models.IntegerField(_(u'Religiosas professas residentes na diocese'), null=True, blank=True)
        diaconospermanentes = models.IntegerField(_(u'Diáconos Permanentes (já ordenados)'), null=True, blank=True)
        candidatossacerdocio = models.IntegerField(_(u'Candidatos ao Sacerdócio (5)'), null=True, blank=True)
        cscelrodiocesano = models.IntegerField(_(u'-  para o clero diocesano'), null=True, blank=True)
        cscleroreligioso = models.IntegerField(_(u'-  para o clero religioso'), null=True, blank=True)
        del1 = models.IntegerField(_(u'Para  candidatos ao sacerdócio'), null=True, blank=True)
        cficlerodiocesano = models.IntegerField(_(u'-  do clero diocesano'), null=True, blank=True)
        cficleroreligioso = models.IntegerField(_(u'-  do clero religioso'), null=True, blank=True)
        del2 = models.IntegerField(_(u'Centros de instrução e educação (6)'), null=True, blank=True)
        cieescolasmaternoinfantis = models.IntegerField(_(u'-  Escolas materno-infantis'), null=True, blank=True)
        cieescolasprimarias = models.IntegerField(_(u'-  Escolas primárias'), null=True, blank=True)
        cieescolassecundarias = models.IntegerField(_(u'-  Escolas secundárias'), null=True, blank=True)
        cieinstitutossuperiores = models.IntegerField(_(u'- Institutos Superiores'), null=True, blank=True)
        cieuniversidadecatolica = models.IntegerField(_(u'- Faculdades da UCP'), null=True, blank=True)
        cashospitais = models.IntegerField(_(u'Hospitais'), null=True, blank=True)
        #del0 = models.IntegerField(_(u' '), null=True, blank=True)
        casambulatorios = models.IntegerField(_(u'Ambulatórios e dispensários'), null=True, blank=True)
        cascasasdeidosos = models.IntegerField(_(u'Casas de idosos, doentes e crónicos  deficientes'), null=True, blank=True)
        casorfanatos = models.IntegerField(_(u'Orfanatos e outros centros de tutela da infância'), null=True, blank=True)
        cascreches = models.IntegerField(_(u'Creches'), null=True, blank=True)
        casconsultoriosfamiliares = models.IntegerField(_(u'Consultórios familiares (8)'), null=True, blank=True)
        cascentrosespeciais = models.IntegerField(_(u'Centros especiais de educação ou reeducação social'), null=True, blank=True)
        cascentrossociais = models.IntegerField(_(u'Centros sociais canonicamente erectos (9)'), null=True, blank=True)
        casconfrarias = models.IntegerField(_(u'Confrarias e Irmandades canonicamente erectas (10)'), null=True, blank=True)
        casmisericordias = models.IntegerField(_(u'Misericórdias (incluídas ou não no já referido)'), null=True, blank=True)
        vsbaptizados = models.IntegerField(_(u'Baptizados'), null=True, blank=True)
        vsate1ano = models.IntegerField(_(u'-  até 1 ano'), null=True, blank=True)
        vsde1a7anos = models.IntegerField(_(u'-  de 1 a 7 anos'), null=True, blank=True)
        vsapos7anos = models.IntegerField(_(u'-  após os 7 anos'), null=True, blank=True)
        vsconfirmacoes = models.IntegerField(_(u'Confirmações'), null=True, blank=True)
        vsprimeirascomunhoes = models.IntegerField(_(u'Primeiras Comunhões'), null=True, blank=True)
        vsmatrimonioscanonicos = models.IntegerField(_(u'Matrimónios canónicos'), null=True, blank=True)
        vsmcentrecatolicos = models.IntegerField(_(u'- entre católicos '), null=True, blank=True)
        vsmcentrecatolicoencatolico = models.IntegerField(_(u'- entre católico e não católico'), null=True, blank=True)
        ecseditorascatolicas = models.IntegerField(_(u'Editoras católicas na diocese (11)'), null=True, blank=True)
        ecslivrarias = models.IntegerField(_(u'Livrarias e distribuidoras católicas (12)'), null=True, blank=True)
        ecsjornaisdiarios = models.IntegerField(_(u'Jornais (13) - Diários'), null=True, blank=True)
        ecsjornaissemanarios = models.IntegerField(_(u'- Semanários'), null=True, blank=True)
        ecsjornaisquinzenarios = models.IntegerField(_(u'- Quinzenários'), null=True, blank=True)
        ecsjornaismensarios = models.IntegerField(_(u'- Mensários'), null=True, blank=True)
        ecsboletinsparoquiais = models.IntegerField(_(u'Boletins Paroquiais e Interparoquiais'), null=True, blank=True)
        ecsradiosregionais = models.IntegerField(_(u'Rádios (14) - Regionais'), null=True, blank=True)
        ecsradioslocais = models.IntegerField(_(u'- Locais'), null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Estatística')
            verbose_name_plural = _(u'Estatísticas')
            abstract = True
            ordering = ['ano']

        def __unicode__(self):
            return str(self.ano)
    return BaseDadosEstatisticos
# Fim Models

# Admin
def getBaseDadosEstatisticosForm(mymodel):
    class BaseDadosEstatisticosForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseDadosEstatisticosForm

def getBaseDadosEstatisticosAdmin(mymodel):
    class BaseDadosEstatisticosAdmin(getBaseAdmin(mymodel)):
        form = getBaseDadosEstatisticosForm(mymodel)
        fieldsets = (
                     (_('1. Dados gerais'), {
                             'fields':(
                                       ('ano',),
                                       ('superficie',),
                                       ('populacao',),
                                       ('catolicos',),
                                       ('arciprestados',),
                                       ('paroquias',),
                                       ('pclerodiocesano',),
                                       ('pcleroreligioso',),
                                       ('poutrosacerdote',),
                                       ('pdiaconosper',),
                                       ('preligiosas',),
                                       ('pleigos',),
                                       ('totalmentevacantes',),
                                       ('capelanias',),
                                       )
                             }),
                     ('2. Clero, Religiosos/as', {
                             'fields':(
                                       ('sacerdotesdiocesanos',),
                                       ('spdiocesepropria',),
                                       ('spnoutradiocese',),
                                       ('foraservicopastoral',),
                                       ('srrdiocese',),
                                       ('srrtotalpartesdiocese',),
                                       ('srrservicoinstituto',),
                                       ('srrforaservicopastoral',),
                                       ('religiososprofessosnsacerdotes',),
                                       ('religiosasprofessasrd',),
                                       ('diaconospermanentes',),
                                       ('candidatossacerdocio',),
                                       ('cscelrodiocesano',),
                                       ('cscleroreligioso',),
                                       )
                             }),
                     ('3. Centros de Formação e Instrução', {
                             'fields':(
                                       ('del1',),
                                       ('cficlerodiocesano',),
                                       ('cficleroreligioso',),
                                       ('del2',),
                                       ('cieescolasmaternoinfantis',),
                                       ('cieescolasprimarias',),
                                       ('cieescolassecundarias',),
                                       ('cieinstitutossuperiores',),
                                       ('cieuniversidadecatolica',),
                                       )
                             }),
                     ('4. Centros de assistência social (7)', {
                             'fields':(
                                       #('del0',),
                                       ('cashospitais',),
                                       ('casambulatorios',),
                                       ('cascasasdeidosos',),
                                       ('casorfanatos',),
                                       ('cascreches',),
                                       ('casconsultoriosfamiliares',),
                                       ('cascentrosespeciais',),
                                       ('cascentrossociais',),
                                       ('casconfrarias',),
                                       ('casmisericordias',),
                                       )
                             }),
                     ('5. Vida Sacramental', {
                             'fields':(
                                       ('vsbaptizados',),
                                       ('vsate1ano',),
                                       ('vsde1a7anos',),
                                       ('vsapos7anos',),
                                       ('vsconfirmacoes',),
                                       ('vsprimeirascomunhoes',),
                                       ('vsmatrimonioscanonicos',),
                                       ('vsmcentrecatolicos',),
                                       ('vsmcentrecatolicoencatolico',),
                                       )
                             }),
                     ('6. Editorial e Comunicações Sociais', {
                             'fields':(
                                       ('ecseditorascatolicas',),
                                       ('ecslivrarias',),
                                       ('ecsjornaisdiarios',),
                                       ('ecsjornaissemanarios',),
                                       ('ecsjornaisquinzenarios',),
                                       ('ecsjornaismensarios',),
                                       ('ecsboletinsparoquiais',),
                                       ('ecsradiosregionais',),
                                       ('ecsradioslocais',),
                                       )
                             }),
                     (None, {
                             'fields':(
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('ano', 'alterado', 'id',)
        search_fields = ('ano', 'id', )

    return BaseDadosEstatisticosAdmin
# Fim Admin
