#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

# Models
def getBaseEcclesia():
    class BaseEcclesia(SharedBase):
        tabela = models.CharField(_(u'Tabela'), max_length=255)
        tipo = models.CharField(_(u'Tipo'), max_length=1)
        codigo = models.IntegerField(_(u'Codigo'))
        #codigo_ecclesia = models.IntegerField(null=True,blank=True)

        class Meta:
            verbose_name = _(u'Ecclesia - Integração')
            verbose_name_plural = _(u'Ecclesia - Integrações')
            abstract = True

        def __unicode__(self):
            return ''
    return BaseEcclesia
# Fim Models

# Admin
def getBaseEcclesiaForm(mymodel):
    class BaseEcclesiaForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseEcclesiaForm

def getBaseEcclesiaAdmin(mymodel):
    class BaseEcclesiaAdmin(getBaseAdmin(mymodel)):
        form = getBaseEcclesiaForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('tabela',),
                                       ('tipo',),
                                       ('codigo',),
                                       )
                             }),
                     )
        list_display = ('tabela', 'tipo', 'codigo', 'codigo_ecclesia', 'id',)
        search_fields = ('tabela', 'tipo', 'codigo_ecclesia', 'id', )

    return BaseEcclesiaAdmin
# Fim Admin
