#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


try:
    from settings import DIOCESE_NOME
    diocese_nome = DIOCESE_NOME
except Exception, e:
    diocese_nome = ''
    pass

# Models
def getBaseGestaoRecursos():
    class BaseGestaoRecursos(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        assuntos_economicos = models.TextField(_(u'Conselho para os assuntos económicos'), null=True, blank=True)
        economo = models.CharField(_(u'Ecónomo'), max_length=255, null=True, blank=True)
        tesouraria = models.CharField(_(u'Tesouraria e contabilidade'), max_length=255, null=True, blank=True)

        class Meta:
            verbose_name = _(u'Gestão de recursos')
            verbose_name_plural = _(u'Gestão de recursos')
            #verbose_name = _(u'Gestão de recursos pessoais, patrimoniais e financeiros')
            #verbose_name_plural = _(u'Gestão de recursos pessoais, patrimoniais e financeiros')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseGestaoRecursos
# Fim Models

# Admin
def getBaseGestaoRecursosForm(mymodel):
    class BaseGestaoRecursosForm(forms.ModelForm):
        nome = forms.CharField(label=(u'Nome'), initial=_(u'Gestão de recursos pessoais, patrimoniais e financeiros de ')+diocese_nome, max_length=255, widget=forms.widgets.TextInput(attrs={'class':'vTextField'}))
        class Meta:
            model = mymodel

    return BaseGestaoRecursosForm

def getBaseGestaoRecursosAdmin(mymodel):
    class BaseGestaoRecursosAdmin(getBaseAdmin(mymodel)):
        form = getBaseGestaoRecursosForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal', 'localidade',),
                                       ('telefone', 'telemovel',),
                                       ('fax', 'email',),
                                       ('paginaweb',),
                                       ('assuntos_economicos',),
                                       ('economo',),
                                       ('tesouraria',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseGestaoRecursosAdmin
# Fim Admin
