#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseInstitutoSecular(INSTITUTOS_CHOICES):
    if INSTITUTOS_CHOICES == None:
        INSTITUTOS_CHOICES = (
              (6, _(u'Ancilla Domini')),
              (7, _(u'Anunciatinas')),
              (8, _(u'Caritas Chisti – C.C.')),
              (9, _(u'Companhia Missionária do Coração de Jesus')),
              (10, _(u'Cooperadoras da Família')),
              (11, _(u'Filiação Cordimariana')),
              (19, _(u'Instituto Secular da Sagrada Família – ISSF')),
              (12, _(u'Instituto Secular do Coração de Jesus – (Família Cor Unum)')),
              (21, _(u'Instituto Servas do Apostolado – ISA')),
              (13, _(u'Irmãs de Maria de Schoenstatt – ISSM')),
              (15, _(u'Missionárias Combonianas')),
              (14, _(u'Missionárias do Amor Misericordioso do Coração de Jesus – MAMCJ')),
              (16, _(u'Nossa Senhora de Schoenstatt – ISNSS')),
              (17, _(u'Padres de Schoenstatt – ISch')),
              (18, _(u'Pequena Família Franciscana')),
              (20, _(u'Santa Família – ISF')),
              (22, _(u'Voluntárias de D. Bosco – VDB')),
        )

    class BaseInstitutoSecular(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        instituto_secular_n_id = models.PositiveIntegerField(_(u'Instituto Secular'), max_length=2, choices=INSTITUTOS_CHOICES, null=True, blank=True)
        comunidade = models.CharField(_(u'Casa/comunidade'), max_length=255, null=True, blank=True)
        director = models.CharField(_(u'Responsável/ Director'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Instituto Secular')
            verbose_name_plural = _(u'Institutos Seculares')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseInstitutoSecular
# Fim Models

# Admin
def getBaseInstitutoSecularForm(mymodel):
    class BaseInstitutoSecularForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseInstitutoSecularForm

def getBaseInstitutoSecularAdmin(mymodel):
    class BaseInstitutoSecularAdmin(getBaseAdmin(mymodel)):
        form = getBaseInstitutoSecularForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('instituto_secular_n_id',),
                                       ('comunidade',),
                                       ('director',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseInstitutoSecularAdmin
# Fim Admin
