#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms

# Models
def getBaseValencias():
    class BaseValencias(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)

        class Meta:
            verbose_name = _(u'Valência')
            verbose_name_plural = _(u'Valências')
            abstract = True

        def __unicode__(self):
            return self.nome
    return BaseValencias

def getBaseObraAccaoSocioCaritativa(basevalencia, VALENCIAS_CHOICES):
    if VALENCIAS_CHOICES == None:
        VALENCIAS_CHOICES = (
            (15, _(u'Apoio domiciliário')),
            (8, _(u'ATL')),
            (16, _(u'Centro de Dia')),
            (3, _(u'Centros Sociais Paroquiais')),
            (6, _(u'Infantários e Creches')),
            (19, _(u'Jardim de Infância')),
            (11, _(u'Lar - Estudantes')),
            (13, _(u'Lar - Idosos')),
            (12, _(u'Lar - Jovens')),
            (9, _(u'Outro')),
            (14, _(u'Patronatos')),
            (20, _(u'Reabilitação e Reinserção Social de Toxicodependentes')),
        )

    class BaseObraAccaoSocioCaritativa(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        tipo = models.PositiveIntegerField(_(u'Valências'), max_length=2, choices=VALENCIAS_CHOICES, default=15)
        multipo_id = models.ManyToManyField(basevalencia, verbose_name=_(u'para instituições com várias valências'), null=True, blank=True)
        propriedade = models.CharField(_(u'Propriedade'), max_length=255, null=True, blank=True)
        responsavel = models.CharField(_(u'Responsável/Director'), max_length=255, null=True, blank=True)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Obra de Acção Sócio Caritativa')
            verbose_name_plural = _(u'Obras de Acção Sócio Caritativa')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseObraAccaoSocioCaritativa
# Fim Models

# Admin
def getBaseObraAccaoSocioCaritativaForm(mymodel, VALENCIAS_CHOICES):
    if VALENCIAS_CHOICES == None:
        VALENCIAS_CHOICES = (
            (15, _(u'Apoio domiciliário')),
            (8, _(u'ATL')),
            (16, _(u'Centro de Dia')),
            (3, _(u'Centros Sociais Paroquiais')),
            (6, _(u'Infantários e Creches')),
            (19, _(u'Jardim de Infância')),
            (11, _(u'Lar - Estudantes')),
            (13, _(u'Lar - Idosos')),
            (12, _(u'Lar - Jovens')),
            (9, _(u'Outro')),
            (14, _(u'Patronatos')),
            (20, _(u'Reabilitação e Reinserção Social de Toxicodependentes')),
        )

    class BaseObraAccaoSocioCaritativaForm(forms.ModelForm):
        multipo_id = forms.MultipleChoiceField(label=_(u'para instituições com várias valências'), choices=VALENCIAS_CHOICES, widget=forms.SelectMultiple, required=False)
        class Meta:
            model = mymodel

    return BaseObraAccaoSocioCaritativaForm

def getBaseObraAccaoSocioCaritativaAdmin(mymodel):
    class BaseObraAccaoSocioCaritativaAdmin(getBaseAdmin(mymodel)):
        form = getBaseObraAccaoSocioCaritativaForm(mymodel, None)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('tipo',),
                                       ('multipo_id',),
                                       ('propriedade',),
                                       ('responsavel',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseObraAccaoSocioCaritativaAdmin
# Fim Admin
