#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseSecretariado():
    class BaseSecretariado(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        director = models.CharField(_(u'Director'), max_length=255, null=True, blank=True)
        coordenador = models.CharField(_(u'Coordenador'), max_length=255, null=True, blank=True)
        assistente = models.CharField(_(u'Assistente'), max_length=255, null=True, blank=True)
        sector_departamento = models.TextField(_(u'Sectores/departamentos'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Secretariado/serviço/departamento')
            verbose_name_plural = _(u'Secretariados/serviços/departamentos')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseSecretariado
# Fim Models

# Admin
def getBaseSecretariadoForm(mymodel):
    class BaseSecretariadoForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseSecretariadoForm

def getBaseSecretariadoAdmin(mymodel):
    class BaseSecretariadoAdmin(getBaseAdmin(mymodel)):
        form = getBaseSecretariadoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('director',),
                                       ('coordenador',),
                                       ('assistente',),
                                       ('sector_departamento',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseSecretariadoAdmin
# Fim Admin
