#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseSeminario():
    class BaseSeminario(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        reitor = models.CharField(_(u'Reitor'), max_length=255, null=True, blank=True)
        vice_reitor = models.CharField(_(u'Vice-Reitor'), max_length=255, null=True, blank=True)
        prefeito = models.CharField(_(u'Prefeito'), max_length=255, null=True, blank=True)
        secretario = models.CharField(_(u'Secretário'), max_length=255, null=True, blank=True)
        confessor = models.CharField(_(u'Confessor'), max_length=255, null=True, blank=True)
        director_espiritual = models.CharField(_(u'Director Espiritual'), max_length=255, null=True, blank=True)
        tesoureiro = models.CharField(_(u'Tesoureiro'), max_length=255, null=True, blank=True)
        economo = models.CharField(_(u'Ecónomo'), max_length=255, null=True, blank=True)
        equipa_resp = models.CharField(_(u'Equipa Responsável'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Obervações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Seminário')
            verbose_name_plural = _(u'Seminários')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseSeminario
# Fim Models

# Admin
def getBaseSeminarioForm(mymodel):
    class BaseSeminarioForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseSeminarioForm

def getBaseSeminarioAdmin(mymodel):
    class BaseSeminarioAdmin(getBaseAdmin(mymodel)):
        form = getBaseSeminarioForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('reitor',),
                                       ('vice_reitor',),
                                       ('prefeito',),
                                       ('secretario',),
                                       ('confessor',),
                                       ('director_espiritual',),
                                       ('tesoureiro',),
                                       ('economo',),
                                       ('equipa_resp',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseSeminarioAdmin
# Fim Admin
