#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from diocesesim.models import getBaseAdmin, SharedBase
from django import forms


# Models
def getBaseTribunalEclesiastico():
    class BaseTribunalEclesiastico(SharedBase):
        nome = models.CharField(_(u'Nome'), max_length=255)
        morada = models.CharField(_(u'Morada'), max_length=255, null=True, blank=True)
        codigo_postal = models.CharField(_(u'Código postal'), max_length=255, null=True, blank=True)
        localidade = models.CharField(_(u'Localidade'), max_length=255, null=True, blank=True)
        telefone = models.CharField(_(u'Telefone'), max_length=255, null=True, blank=True)
        telemovel = models.CharField(_(u'Telemóvel'), max_length=255, null=True, blank=True)
        fax = models.CharField(_(u'Fax'), max_length=255, null=True, blank=True)
        email = models.CharField(_(u'Email'), max_length=255, null=True, blank=True)
        paginaweb = models.CharField(_(u'Página web'), max_length=255, null=True, blank=True)
        vigario_judicial = models.CharField(_(u'Vigário Judicial'), max_length=255, null=True, blank=True)
        vigariojudicialad = models.CharField(_(u'Vigário Judicial Adjunto'), max_length=255, null=True, blank=True)
        juizes_diocesanos = models.TextField(_(u'Juizes Diocesanos'), null=True, blank=True)
        auditores = models.TextField(_(u'Auditores'), null=True, blank=True)
        promotor_justica = models.CharField(_(u'Promotor da Justiça'), max_length=255, null=True, blank=True)
        defensor_vinculo = models.CharField(_(u'Defensor do Vínculo'), max_length=255, null=True, blank=True)
        notario_actuario = models.CharField(_(u'Notário actuario'), max_length=255, null=True, blank=True)
        advogados_oficio = models.TextField(_(u'Advogados ofício'),  null=True, blank=True)
        meirinho = models.CharField(_(u'Meirinho'), max_length=255, null=True, blank=True)
        obs = models.TextField(_(u'Observações'), null=True, blank=True)

        class Meta:
            verbose_name = _(u'Tribunal Eclesiástico')
            verbose_name_plural = _(u'Tribunais Eclesiástico')
            abstract = True
            ordering = ['nome']

        def __unicode__(self):
            return self.nome
    return BaseTribunalEclesiastico
# Fim Models

# Admin
def getBaseTribunalEclesiasticoForm(mymodel):
    class BaseTribunalEclesiasticoForm(forms.ModelForm):
        class Meta:
            model = mymodel

    return BaseTribunalEclesiasticoForm

def getBaseTribunalEclesiasticoAdmin(mymodel):
    class BaseTribunalEclesiasticoAdmin(getBaseAdmin(mymodel)):
        form = getBaseTribunalEclesiasticoForm(mymodel)
        fieldsets = (
                     (None, {
                             'fields':(
                                       ('nome',),
                                       ('morada',),
                                       ('codigo_postal','localidade',),
                                       ('telefone','telemovel',),
                                       ('fax','email',),
                                       ('paginaweb',),
                                       ('vigario_judicial',),
                                       ('vigariojudicialad',),
                                       ('juizes_diocesanos',),
                                       ('auditores',),
                                       ('promotor_justica',),
                                       ('defensor_vinculo',),
                                       ('notario_actuario',),
                                       ('advogados_oficio',),
                                       ('meirinho',),
                                       ('obs',),
                                       )
                             }),
                     )
        list_display = ('nome', 'alterado', 'id',)
        search_fields = ('nome', 'id', )

    return BaseTribunalEclesiasticoAdmin
# Fim Admin
