from django import template
from django.conf import settings
from django.contrib.sites.models import Site
from django.utils.translation import ugettext as _

register = template.Library()

@register.simple_tag
def atb_site_name():
    if 'django.contrib.sites' in settings.INSTALLED_APPS:
        return Site.objects.get_current().name
    else:
        return _('Django site')
