#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from diocese import models as dioceseModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from django.conf import settings
    from elfinder.models import FileCollection,Directory
    import os.path
    import os
    import shutil
    from exceptions import IOError



    class ImportArciprestadoPresbitero(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_arciprestados_aux WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    obj = dioceseModels.Arciprestado.objects.get(pk=linha['cod_arciprestado'])
                    self.obj.dioceses_presbiteroarciprestados_presbiteroarciprestados_presbitero.create(
                                                        presbitero = self.obj,
                                                        arciprestado = obj,
                                                        )                       

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_clero': row[1],
                    'cod_arciprestado': row[2],
                    }

    class ImportPresbitero(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE (cod_tipo_clero=1 or cod_tipo_clero=3 or  cod_tipo_clero=4 or  cod_tipo_clero=5)')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Presbitero.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportArciprestadoPresbitero(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    }






    class ImportArciprestadoDiacono(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_arciprestados_aux WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    obj = dioceseModels.Arciprestado.objects.get(pk=linha['cod_arciprestado'])
                    self.obj.dioceses_diaconoarciprestados_diaconoarciprestados_diacono.create(
                                                        diacono = self.obj,
                                                        arciprestado = obj,
                                                        )                       

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_clero': row[1],
                    'cod_arciprestado': row[2],
                    }

    class ImportDiacono(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=9')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Diacono.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportArciprestadoDiacono(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    }





    class ImportArciprestadoBispo(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_arciprestados_aux WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    obj = dioceseModels.Arciprestado.objects.get(pk=linha['cod_arciprestado'])
                    self.obj.dioceses_bispoarciprestados_bispoarciprestados_bispo.create(
                                                        bispo = self.obj,
                                                        arciprestado = obj,
                                                        )                       

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_clero': row[1],
                    'cod_arciprestado': row[2],
                    }

    class ImportBispo(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=8')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.Bispo.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportArciprestadoBispo(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    }





    class ImportArciprestadoDiaconoPermanente(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero_arciprestados_aux WHERE cod_clero="'+str(self.obj.id)+'"')
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    obj = dioceseModels.Arciprestado.objects.get(pk=linha['cod_arciprestado'])
                    self.obj.dioceses_diaconopermanentearciprestados_diaconopermanentearciprestados_diaconopermanente.create(
                                                        diaconopermanente = self.obj,
                                                        arciprestado = obj,
                                                        )                       

                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'cod_clero': row[1],
                    'cod_arciprestado': row[2],
                    }

    class ImportDiaconoPermanente(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM clero WHERE cod_tipo_clero=7')
            for row in self.cur:
                linha = self.getLinha(row)
                try:
                    obj = dioceseModels.DiaconoPermanente.objects.get(
                                                        pk = linha['id']
                                                        )

                    ImportArciprestadoDiaconoPermanente(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    }




    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportPresbitero(con, cur).importar()
        ImportDiaconoPermanente(con, cur).importar()
        ImportBispo(con, cur).importar()
        ImportDiacono(con, cur).importar()



    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


