#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from newsletter import models as conteudoModels
    from django.contrib.auth.models import User
    from datetime import datetime

    from website import models as modelsWebsite

    def get_fromtimestamp(val):
        if val is None:
            return None
        try:
            return datetime.fromtimestamp(val)
        except Exception, e:
            print e
            return None

    def get_strpdate(val):
        if val is None:
            return None
        try:
            return val
        except Exception, e:
            print e
            return None







    class ImportAssinante(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT DISTINCT * FROM utilizadores_newsletter WHERE codigo in (SELECT cod_registo FROM grupos_registos WHERE tabela="utilizadores_newsletter")' )
            for row in self.cur:
                linha = self.getLinha(row)
                try:

                    self.cur.execute('SELECT grupos_newsletter.* \
                        FROM grupos_newsletter \
                        LEFT JOIN grupos_registos ON grupos_registos.cod_grupo=grupos_newsletter.codigo \
                        WHERE grupos_registos.tabela = "utilizadores_newsletter" \
                        AND grupos_registos.cod_registo="'+str(linha['id'])+'"')
                    
                    for row1 in self.cur:
                        linha1 = self.getLinha1(row1)                        
                        try:

                                assinante = conteudoModels.User.objects.filter(email=linha['email'], website=linha1['cod_utilizador'])
                                
                                if len(assinante)==0:
                                    obj = conteudoModels.User.objects.create(
                                                                        email = linha['email'],
                                                                        aproved = linha['aproved'],
                                                                        aprove_key = linha['aprove_key'],
                                                                        website = modelsWebsite.WebSite.objects.get(pk=linha1['cod_utilizador']),
                                                                        )
                                else:
                                    obj = assinante[0]

                                    try:
                                        grupos = obj.groups.filter(id=linha1['codigo'])                                        

                                        if len(grupos)==0:
                                            grupo = conteudoModels.Group.objects.get(pk=linha1['codigo'])

                                            obj.usergroup_user.create(
                                                                    user = obj,
                                                                    group = grupo,
                                                                    )

                                    except Exception, e:
                                        print str(e)
                                    pass
                        except Exception, e:
                            print str(e)
                            pass

                except Exception, e:
                    print str(e)
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'email': row[1],
                    'aproved': row[2],
                    'aprove_key': row[5],
                    'website': 1,
                    }
        def getLinha1(self, row):
            #print row
            return {
                    'codigo': row[0],
                    'titulo': row[1],
                    'criado_por': row[2],
                    'timestamp': row[3],
                    'cod_utilizador': row[4],
                    }


    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """

        ImportAssinante(con, cur).importar()



    except mdb.Error, e:
        print "Error %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)
    finally:
        if con:
            con.close()

    print 'END'


