#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:

    from django.contrib.auth.models import User, Group


    class UserGroups(object):

        def __init__(self, obj, conn, cur):
            self.obj = obj
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM grupos_utilizadores WHERE cod_utilizador=%s' % self.obj.id)
            mylist=[]
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    mylist.append(linha['cod_grupo'],);
                except Exception, e:
                    print e
                    pass

            obj = User.objects.get(pk=self.obj.id)
            obj.groups=Group.objects.filter(pk__in=mylist)
            obj.save()
        def getLinha(self, row):
            #print row
            return {
                    'cod_grupo': row[1]
                    }



    class ImporGroup(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM grupos')
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    """
                    if linha['id']==1:
                        obj = User.objects.get(pk=101)
                        obj.id=linha['id']
                        obj.username =  linha['username']
                        obj.password =  linha['password']
                        obj.email =  linha['email']
                        obj.save()
                    else:
                    """
                    Group.objects.create(
                                                        id = linha['id'],
                                                        name =  linha['name']
                                                        )
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'name': row[1]
                    }



    class ImportUser(object):

        def __init__(self, conn, cur):
            self.conn = conn
            self.cur = cur
            #self.User = User.objects.get(pk=101)

        def importar(self):
            self.cur.execute('SELECT * FROM utilizadores')
            for row in self.cur:
                linha = self.getLinha(row)

                try:
                    """
                    if linha['id']==1:
                        obj = User.objects.get(pk=101)
                        obj.id=linha['id']
                        obj.username =  linha['username']
                        obj.password =  linha['password']
                        obj.email =  linha['email']
                        obj.save()
                    else:
                    """
                    obj = User.objects.create(
                                                        id = linha['id'],
                                                        username =  linha['username'],
                                                        #password =  linha['password'],
                                                        email =  linha['email'],
                                                        #first_name =  linha['first_name'],
                                                        #last_name =  linha['last_name'],
                                                        is_staff =  linha['is_staff'],
                                                        is_active =  linha['is_active'],
                                                        #is_superuser =  linha['is_superuser'],
                                                        #last_login =  linha['last_login'],
                                                        #date_joined =  linha['date_joined'],
                                                        )
                    obj.set_password(linha['password'])
                    obj.save()
                    UserGroups(obj, self.conn, self.conn.cursor()).importar()
                except Exception, e:
                    print e
                    pass

        def getLinha(self, row):
            #print row
            return {
                    'id': row[0],
                    'username': row[5],
                    'password': row[6],
                    'email': row[28],
                    #'first_name': row[4],
                    #'last_name': row[5],
                    'is_staff': 1,
                    'is_active': 1,
                    #'is_superuser': row[8],
                    #'last_login': row[9],
                    #'date_joined': row[10]
                    }



    print 'BEGIN'

    import MySQLdb as mdb
    import sys

    con = None

    try:

        con = mdb.connect(django_settings.SIM4_CONN[0],django_settings.SIM4_CONN[1],django_settings.SIM4_CONN[2],django_settings.SIM4_CONN[3],charset="utf8");

        #con.set_character_set('utf8')

        cur = con.cursor()
        """
        cur.execute('SET NAMES utf8;')
        cur.execute('SET CHARACTER SET utf8;')
        cur.execute('SET character_set_connection=utf8;')
        """
        """
        cur.execute("SELECT VERSION()")

        data = cur.fetchone()

        print "Database version : %s " % data
        """
        ImporGroup(con, cur).importar()
        ImportUser(con, cur).importar()

    except mdb.Error, e:

        print "Error %d: %s" % (e.args[0],e.args[1])
        sys.exit(1)

    finally:

        if con:
            con.close()

    print 'END'









