#coding: utf-8
from django.contrib import admin

from actions import delete_selected
from diocese import models_ecclesia as modelsEcclesia

from django.forms.util import ErrorList

from django.db.models import get_model
from django import forms
import re

from django.core.urlresolvers import resolve

class MyBaseForm(forms.ModelForm):
    appmodel=None

    def __init__(self, *args, **kwargs):
        self.request = kwargs.pop('request', None)
        self.appmodel = kwargs.pop('appmodel', None)
        super(MyBaseForm, self).__init__(*args, **kwargs)

        try:
            #if self.request.user.is_superuser:
            #    userwebsites = get_model('website','WebSite').objects.all()
            #else:
            if self.request:
                userwebsites = self.request.user.websites_websites_users.all()
            else:
                userwebsites = None
        except Exception, e:
            userwebsites = None

        if self.appmodel=='agenda.agenda':
            self.fields['entidade'].queryset = get_model('agenda','AgendaEntidade').objects.filter(website__in = userwebsites)
            self.fields['local'].queryset = get_model('agenda','AgendaLocal').objects.filter(website__in = userwebsites)
        elif self.appmodel=='conteudos.seccao':
            self.fields['parent'].queryset = get_model('conteudos','Seccao').objects.filter(website__in = userwebsites)
        elif self.appmodel=='sitemenu.menutree':
            self.fields['parent'].queryset = get_model('sitemenu','MenuTree').objects.filter(website__in = userwebsites)

    def save(self, *args, **kwargs):
        return super(MyBaseForm, self).save(*args, **kwargs)

    def clean(self):

        if str(self._meta.model._meta)=='website.website':
        
            url_existe=False
            url_path='/'

            try:
                url_param = self.cleaned_data.get('url')
                if url_param:

                    url_path = url_param.replace('/'.join(url_param.split("/")[:3]),'')
                    if not url_param[len(url_param)-1] == '/':
                        url_path+='/'

                    url_path=resolve(url_path)

                    if not url_path.url_name.startswith('paroquia_'):
                        url_existe=True

                    if url_existe and re.search(r"[a-z-]", url_param):
                        self._errors["url"] = ErrorList([u"O url já se encontra reservado."])
                
            except Exception, e:
                #print e
                pass

        return self.cleaned_data


class MyBaseAdmin(admin.ModelAdmin):
    form = MyBaseForm
    def save_model(self, request, obj, form, change):
        if not change:
            userwebsites=request.user.websites_websites_users.all()
            if userwebsites:
                obj.website=userwebsites[0]
        super(MyBaseAdmin, self).save_model(request, obj, form, change)

    def queryset(self, request):
 
        #if request.user.is_superuser:
        #    return super(MyBaseAdmin, self).queryset(request).all()

        if self.model._meta.module_name=='website':
            return super(MyBaseAdmin, self).queryset(request).filter(id__in = request.user.websites_websites_users.all())
        else:
            return super(MyBaseAdmin, self).queryset(request).filter(website__in = request.user.websites_websites_users.all())

    def get_form(self, request, obj=None, **kwargs):
        ModelForm = super(MyBaseAdmin, self).get_form(request, obj, **kwargs)
        #if request.user.is_superuser:
        #    return ModelForm
        #else:
        class ModelFormMetaClass(ModelForm):
            def __new__(cls, *args, **kwargs):
                kwargs['request'] = request
                kwargs['appmodel'] = self.model._meta.app_label+str('.')+self.model._meta.module_name
                return ModelForm(*args, **kwargs)
        return ModelFormMetaClass


class MyDioceseAdmin(admin.ModelAdmin):
    def save_model(self, request, obj, form, change):
        if not change:
            tipo = 'I'
        else:
            tipo = 'U'
        super(MyDioceseAdmin, self).save_model(request, obj, form, change)
        ecclesia = modelsEcclesia.Ecclesia(tabela=obj._meta.db_table,
            tipo=tipo, codigo=obj.id,
            codigo_ecclesia=obj.codigo_ecclesia, criado_por=request.user,
            alterado_por=request.user)
        ecclesia.save()

    def delete_model(self, request, obj):
        ecclesia = modelsEcclesia.Ecclesia(tabela=obj._meta.db_table, tipo='D',
            codigo=obj.id, codigo_ecclesia=obj.codigo_ecclesia,
            criado_por=request.user, alterado_por=request.user)
        ecclesia.save()
        super(MyDioceseAdmin, self).delete_model(request, obj)

    def get_actions(self, request):
        actions = super(MyDioceseAdmin, self).get_actions(request)
        if 'delete_selected' in actions:
            actions['delete_selected'] = (
                delete_selected,
                'delete_selected',
                delete_selected.short_description
            )
        return actions

