#coding: utf-8
from django.contrib import admin
from newsletter import models as MODnewsletter
from newsletter import inlines as INLnewsletter
from django.utils.translation import ugettext_lazy as _


from myadmin.admin import MyBaseAdmin


class BaseAdmin(admin.ModelAdmin):
    change_list_template = 'actionslistview.html'
    row_actions = []




from django.utils.translation import ugettext_lazy as _
from django.contrib.admin import SimpleListFilter
from django.db.models import get_model

class GroupsListFilter(SimpleListFilter):       
  
    title = ('groups')
    parameter_name = 'groups__id__exact'
     
    def lookups(self, request, model_admin):
        #if request.user.is_superuser:
        #    userwebsites = get_model('website','WebSite').objects.all()
        #else:
        if request:
            userwebsites = request.user.websites_websites_users.all()
        else:
            userwebsites = None

        seccoes = get_model('newsletter','Group').objects.filter(website__in = userwebsites)#.order_by('name')
        lookup_choices = []
        for seccao in seccoes:
            lookup_choices.append((seccao.pk, seccao.title))
     
        return lookup_choices
     
    def queryset(self,request,queryset):
        pass            
        #if self.value():
        #    return queryset.filter(groups__id__exact=self.value())
        #return queryset.filter(seccoes__exact=self.value())




# Users
class UserAdmin(MyBaseAdmin, BaseAdmin):
    save_on_top = True
    list_display = ('email', 'aproved', 'get_groups', 'id')
    search_fields = ('id', 'email', )
    list_filter = ('aproved', GroupsListFilter)#'groups'
    exclude = ('groups','website',)

    inlines = [INLnewsletter. UserGroupInline]

    def get_groups(self, e):
        grps = []
        z = e.groups.all().values('title')

        for g in z:
            grps.append(g['title'])

        if len(grps) == 0:
            return None

        return ', '.join(grps)

    get_groups.short_description = _(u'Grupos')

admin.site.register(MODnewsletter.User, UserAdmin)
# ---------------------


# Groups
class GroupAdmin(MyBaseAdmin, BaseAdmin):
    save_on_top = True
    list_display = ('title', 'id')
    search_fields = ('id', 'title')
    exclude = ('website','ref',)

admin.site.register(MODnewsletter.Group, GroupAdmin)
# ---------------------


# Newsletter
from newsletter.forms import NewsletterForm
class NewsletterAdmin(MyBaseAdmin, BaseAdmin):
    form = NewsletterForm
    save_on_top = True
    list_display = ('title', 'active', 'id')
    search_fields = ('id', 'title', )
    exclude = ('website','ref',)

    fieldsets = (
                 (_(u'Newsletter'), {
                                     'fields': (
                                                'active', #'website', 'ref', 
                                                'title',
                                                ('start_date', 'last_sended'),
                                                'ntype',
                                                'subject', 'body'
                                                )
                                     }),
                 (_(u'Especiais'), {
                                   'fields': (
                                              'send_pdf_destaque',
                                              'send_news',
                                              'send_news_number'
                                              ),
                                   'classes': ['collapse', ],
                                   })
                 )

    inlines = [
               INLnewsletter.NewsletterGroupInline,
               INLnewsletter.UserInline,
               INLnewsletter.NewsInline,
               #INLnewsletter.SectionsInline,
               ]

admin.site.register(MODnewsletter.Newsletter, NewsletterAdmin)
# ---------------------


# Quee
class QueeAdmin(BaseAdmin):
    save_on_top = True
    list_display = ('from_mail', 'to_mail', 'subject', 'trys', 'data', 'id',)
    search_fields = ('id', 'from_mail', 'to_mail', 'subject', 'body')

admin.site.register(MODnewsletter.Quee, QueeAdmin)
# ---------------------


#Templates
from peakitcms.conteudos.templates.models import getBaseTemplateAdmin


class TemplateAdmin(getBaseTemplateAdmin(
    MODnewsletter.NewsletterTemplate)):
    inlines = [INLnewsletter.NewsletterTemplateTagInline, ]
admin.site.register(MODnewsletter.NewsletterTemplate, TemplateAdmin)
