# -*- coding: utf-8 *-*
from tastypie import fields
from tastypie.resources import ModelResource
from newsletter.models import Newsletter, NewsletterTemplate, NewsletterTemplateTag


class NewsletterResource(ModelResource):
    class Meta:
        queryset = Newsletter.objects.all()
        resource_name = 'newsletter'


class NewsletterTemplateTagResource(ModelResource):

    class Meta:
        queryset = NewsletterTemplateTag.objects.all()


class NewsletterTemplateResource(ModelResource):
    tags = fields.ToManyField(NewsletterTemplateTagResource,
        'newslettertemplatetag_set', full=True)

    class Meta:
        queryset = NewsletterTemplate.objects.filter(activo=True)

    def dehydrate(self, bundle):
        #bundle.data['tags'] = bundle.obj.newslettertemplatetag_set.all()
        return bundle
