# -*- coding: utf-8 *-*
from django import forms
from django.utils.safestring import mark_safe
from django.forms.widgets import Textarea
#from django.contrib.auth import models as auth_models
from django.utils.translation import ugettext_lazy as _

from newsletter.models import Newsletter, NewsletterNew, NewsletterTemplate

from tinymce.widgets import TinyMCE

from myadmin.admin import MyBaseForm

from redactor.widgets import JQueryEditor as RedactorEditor


#class NewsletterBodyTemplateWidget(TinyMCE):
class NewsletterBodyTemplateWidget(RedactorEditor):
    trim_javascript = False

    def get_ajax(self, name):
        ajax_0 = """
        function getselect(){
            return "<select onchange=\\"django.jQuery(this).parent().parent().find('input')[0].value=this.value\\"><option>%s</option></select>";
        }
        """ % unicode(_(u'Seleccione uma tag'))
        tmp = """
div = django.jQuery("#%s-empty > fieldset > div.%s > div");
select = django.jQuery(getselect());
django.jQuery('#%s_hidden_holder > select').find('option').clone().appendTo(select);
if(django.jQuery('#%s-__prefix__-%s-holder').length!=0)
{
    div_insert = django.jQuery('#%s-__prefix__-%s-holder');
    div_insert.html('');
}
else
{
    div_insert = django.jQuery('<span id="%s-__prefix__-%s-holder"></span>');
    div_insert.appendTo(div);
}
select.appendTo(div_insert);
        """ % (
            self.prefix, self.field_replaced, name,
            self.prefix, self.field_replaced, self.prefix,
            self.field_replaced, self.prefix, self.field_replaced
            )

        if self.trim_javascript:
            tmp = ''.join(tmp.split())
        ajax_1 = 'function load_inline_tags_%s(){%s}' % (
            name, tmp
            )

        tmp = """
val = django.jQuery('#select_id_%s$SPACE$option:selected').val();
if(val){
    django.jQuery.getJSON('%s' + val + '/?format=json',
        function(data){
            my_obj = django.jQuery('#id_%s');
            if(confirm("%s")){
                django.jQuery('#id_%s').setCode('<p>'+data['%s']+'</p>');
            }
            else{
                    django.jQuery('#id_%s').setCode('<p>'+django.jQuery('#id_%s').getText()+data['%s']+'</p>');
            }
            select = django.jQuery('<select></selec>');
            tags = data['tags'];
            django.jQuery('#%s_hidden_holder').html('');
            if(tags.length>0){
                for(var$SPACE$v$SPACE$in$SPACE$tags)
                {
                    select.append('<option value="'+tags[v].tag+'">'+tags[v].tag+'</option>');
                }
                django.jQuery('#%s_hidden_holder').append(select);
            }
            load_inline_tags_%s();
    });
}
else{
    alert("%s");
}
        """ % (name, self.ajax['url'], name,
            unicode(_(u'Clear$SPACE$before$SPACE$change?')), name,
            self.ajax['value_field'], name, name, self.ajax['value_field'], name, name, name,
            unicode(_(u'You$SPACE$must$SPACE$select$SPACE$before$SPACE$load!!')
            ))

        if self.trim_javascript:
            tmp = ''.join(tmp.split())
        ajax_2 = 'function load_%s(){%s}' % (
            name, tmp
            )
        ajax_2 = ' '.join(ajax_2.split('$SPACE$'))

        scripts = """<script>%s%s%s</script>
        """ % (ajax_0, ajax_1, ajax_2)
        return scripts

    def get_select(self, model, default_model, name):
        select = mark_safe(u'<select id="select_id_%s">' % name)
        if default_model:
            select += mark_safe(u'<option value="">%s</option>' %
                default_model)
        for v in model:
            select += mark_safe(u'<option value="%s">%s</option>' %
            (v.pk, str(v)))
        select += mark_safe(u'</select>')
        return select

    def get_load_button(self, name):
        botao = mark_safe(
            u'<input type="button" value="Load" onclick="load_%s()"/><div id="%s_hidden_holder" style="display:none;"></div>' % (name, name))
        return botao

    def render(self, name, value, attrs=None):
        (model, default_model) = (None, None)
        if 'model' in self.attrs:
            model = self.attrs['model']
            default_model = self.attrs.pop('default_model', None)
            self.ajax = self.attrs.pop('ajax', None)
            self.prefix = self.attrs.pop('prefix', None)
            self.field_replaced = self.attrs.pop('field_replaced', None)
            self.attrs.pop('model', None)
        val = super(NewsletterBodyTemplateWidget, self).render(name, value,
            attrs)

        if model is None:
            return val
        else:
            select = self.get_select(model, default_model, name)
            botao = self.get_load_button(name)
            return mark_safe(u'%s<div style="float:left;"><div>%s %s</div>'
                '<div>%s</div></div>' % (self.get_ajax(name), select, botao,
                    val))


class NewsletterForm(MyBaseForm, forms.ModelForm):

    class Meta:
        model = Newsletter
        widgets = {
            'body': NewsletterBodyTemplateWidget(attrs={
                'cols': 80,
                'rows': 10,
                'model': NewsletterTemplate.objects.all(),
                'default_model': _(u'Escolha um template aqui'),
                'prefix': 'newsletters_newsletternews_newsletter',
                'field_replaced': 'tag',
                'ajax': {
                    'url': '/newsletter/api/v1/newslettertemplate/',
                    'value_field': 'template'
                }})
        }


class NewForm(forms.ModelForm):

    class Meta:
        model = NewsletterNew
