#coding: utf-8
from newsletter import models as MODnewsletter
from django.contrib import admin
from django.forms.models import BaseInlineFormSet
from django.utils.translation import ugettext_lazy as _
from inline_ordering.admin import OrderableStackedInline

from newsletter.forms import NewForm


class MyInlineFormSet(BaseInlineFormSet):
    def _construct_form(self, i, **kwargs):
        form = super(MyInlineFormSet, self)._construct_form(i, **kwargs)
        form.empty_permitted = True
        return form


class BaseInline(admin.TabularInline):
    extra = 0
    formset = MyInlineFormSet


# User
class UserGroupInline(BaseInline):
    """"""
    model = MODnewsletter.UserGroup
    raw_id_fields = ('group',)
# ---------------------


# NewsletterGroup
class NewsletterGroupInline(BaseInline):
    """"""
    model = MODnewsletter.NewsletterGroup
    raw_id_fields = ('group',)
# ---------------------


# Section
class SectionsInline(BaseInline):
    """"""
    model = MODnewsletter.NewsletterSection
    raw_id_fields = ('section',)
# ---------------------


#Users
class UserInline(BaseInline):
    """"""
    model = MODnewsletter.NewsletterUser
    raw_id_fields = ('user',)
# ---------------------


#Users
class NewsInline(OrderableStackedInline):
    """"""
    form = NewForm
    extra = 0
    model = MODnewsletter.NewsletterNew
    raw_id_fields = ('news',)

    class Media:
        js = ('admin/js/jquery-ui.min.js', 'inline_ordering.js')
# ---------------------


#TemplateTag
class NewsletterTemplateTagInline(BaseInline):
    """"""
    model = MODnewsletter.NewsletterTemplateTag
# ---------------------
