#coding: utf-8
from django.core.management.base import BaseCommand, CommandError
from newsletter import models as MODnewsletter
from datetime import datetime, timedelta
from heapq import merge
from my_utils.Mailer import Mailer
from django.conf import settings as django_settings
from django.db.models import Q
from sorl.thumbnail import get_thumbnail
#from django.core.paginator import Paginator

class Command(BaseCommand):
    """
    Vais buscar todas as configurações usadas pelo cron às settings definidas no projecto
    # Newsletter Settings
    NEWSLETTER_FROM_EMAIL = ''
    NEWSLETTER_DISPATCHER = 'self'
    NEWSLETTER_MAX_TO_DISPATCH = 500
    #NEWSLETTER_QUEE_DISPATCH_GROUP = 10 #Ainda nao foi implementado
    #---------------------
    """
    def __init__(self, *args, **kwargs):
        super(Command, self).__init__(*args, **kwargs)

        self.newsletter_dispatcher = None
        if hasattr(django_settings, 'NEWSLETTER_DISPATCHER'):
            self.newsletter_dispatcher = django_settings.NEWSLETTER_DISPATCHER
        
        self.max_to_dispatch = 500
        if hasattr(django_settings, 'NEWSLETTER_MAX_TO_DISPATCH'):
            self.max_to_dispatch = int(django_settings.NEWSLETTER_MAX_TO_DISPATCH)
        
        """
        self.quee_dispatch_group = 10
        if hasattr(django_settings, 'NEWSLETTER_QUEE_DISPATCH_GROUP'):
            self.quee_dispatch_group = django_settings.NEWSLETTER_QUEE_DISPATCH_GROUP
        """
    
    """
    Trata de decidir o que fazer conforme o que recebe na consola
    """
    def handle(self, *args, **options):
        if 'add_quee' in args:
            print datetime.now()
            self.add_quee()
        else:
            if 'dispatch_quee' in args:
                print datetime.now()
                self.dispatch_quee()
    
    """
    Adiciona todas as newsletter à quee
    """
    def add_quee(self):
        self.stdout.write('Iniciar add_quee\n')
        agora = datetime.now()
        newsletter = MODnewsletter.Newsletter.objects.filter(Q(active=True), Q(start_date__lte=agora))
        for n in newsletter:
            if self.ok_newsletter(n):
                self.send_newsletter(n)
        self.stdout.write('Fim add_quee\n')

    def ok_newsletter(self, n):
        if n.last_sended is None: #Não interessa o tipo, se nunca mandou vai mandar
            return True
        dia_enviada = datetime(n.last_sended.year,n.last_sended.month,n.last_sended.day,n.start_date.hour,n.start_date.minute,n.start_date.second)
        hoje = datetime.today()
        if n.type==1: #Diária
            z = datetime.now()-dia_enviada
            if z.days>0:
                return True
        if n.type==2: #Semanal
            if dia_enviada<=hoje + timedelta(days=-7):
                return True
        if n.type==3: #Mensal
            if dia_enviada<=hoje + timedelta(days=-30):
                return True
        if n.type==4: #Anual
            if dia_enviada<=hoje + timedelta(days=-365):
                return True
        return False
        
            
    """
    Envia emails na nossa quee
    """
    def dispatch_quee(self):
        self.stdout.write('Iniciar dispatch_quee\n')
        if self.max_to_dispatch is None:
            quee = MODnewsletter.Quee.objects.all()
        else:
            quee = MODnewsletter.Quee.objects.all()[:self.max_to_dispatch]
        
        for e in quee:
            mailer = Mailer(e.from_mail, e.to_mail, e.subject, e.body)
            
            if mailer.send() or e.trys==3:
                e.delete()
            else:
                e.trys += 1
                e.save()
        self.stdout.write('Fim dispatch_quee\n')
    
    """
    Insere emails de uma newsletter na nossa quee 
    """
    def send_newsletter(self, newsletter):
        self.stdout.write('Iniciar send_newsletter: %s\n' % newsletter.id)
        emails = self.getallemails(newsletter)
        
        
        body = self.parse_newsletter(newsletter, newsletter.send_news, newsletter.send_pdf_destaque)
            
        for e in emails:
            mailer = Mailer(django_settings.NEWSLETTER_FROM_EMAIL, emails[e].email, newsletter.subject, body)
            mailer.dispatcher = self.newsletter_dispatcher
            mailer.send()
            self.stdout.write('Inserido: %s\n' % emails[e].email)
        
        newsletter.last_sended = datetime.now()
        newsletter.save()
        self.stdout.write('Fim send_newsletter: %s\n' % newsletter.id)
    
    
    def parse_newsletter(self, newsletter, news, send_pdf_destaque):
        from django.template import Context, Template
        from contents import models as MODcontents
        mail_context = {}
        template = Template(newsletter.body)
        mail_context = {}
        meses = {
                 1:u'Janeiro', 
                 2:u'Fevereiro', 
                 3:u'Março', 
                 4:u'Abril', 
                 5:u'Maio', 
                 6:u'Junho', 
                 7:u'Julho', 
                 8:u'Agosto', 
                 9:u'Setembro', 
                 10:u'Outubro', 
                 11:u'Novembro', 
                 12:u'Dezembro'
                 }
        mail_context['meses'] = meses
        agora = datetime.now()
        hoje = datetime.today()
        mail_context['data'] = {
                                'dia':agora.day,
                                'mes':agora.month,
                                'ano':agora.year,
                                'mes_extenso': meses[agora.month]
                                }
        if news:
            noticias = MODcontents.Content.objects.filter(Q(published=True),Q(published_on__lte=agora),Q(content_type=0)).values('id', 'title','cover','resume','contents','cover').order_by('-published_on')[:newsletter.send_news_number]
            mail_context['noticias'] = noticias
        if send_pdf_destaque:
            c = MODcontents.Content.objects.filter(published=True, content_type = 7, published_on__lte=agora).filter(Q(expiration_date__isnull=True) | Q(expiration_date__gte=hoje)).values('cover','id').order_by('-published_on')[:1]
        if len(c)==1:
            mail_context['edicao_pdf'] = c[0]
        return template.render( Context(mail_context) )
    
    """
    Retorna todos os emails de uma newsletter
    """
    def getallemails(self,newsletter):
        grupos = self.get_groups(newsletter)
        utilizadores = {}
        for g in grupos:
            lusrs = self.get_users(g)
            for u in lusrs:
                if not u.id in utilizadores:
                    utilizadores[u.id] = u
        
        return utilizadores
    
    """
    Retorna todos os grupos de uma newsletter
    """
    def get_groups(self, newsletter):
	return newsletter.groups.all()
    
    """
    Retorna todos os emails de um grupo
    """
    def get_users(self, group):
        return MODnewsletter.User.objects.filter(Q(groups__id=group.id), Q(aproved=True))
    
