#coding: utf-8
from django.conf import settings as django_settings

if not hasattr(django_settings, 'SIM4_CONN'):
    #raise Exception('SIM4_CONN não existe no ficheiro de settings.py\nExemplo:\n\tSIM4_CONN = "dbname=\'db_name\' user=\'db_user\' host=\'db_host\' password=\'db_password\'"')
    pass
else:
    import psycopg2
    import psycopg2.extras
    from django.contrib.auth.models import User
    from newsletter import models as MODnewsletter


    class IMPORTSIM4(object):
        modulo = ""

        def startCounter(self):
            self.counter = 1

        def plusCounter(self):
            cnt = self.counter
            self.counter += 1
            return cnt

        def __init__(self):
            self.conn = psycopg2.connect(django_settings.SIM4_CONN)
            self.cur = self.conn.cursor('cursor_unique_name', cursor_factory=psycopg2.extras.DictCursor)
            self.User = User.objects.get(pk=101)

        def importar(self):
            print 'A importar %s' % self.modulo

    class NewsletterGroups(IMPORTSIM4):
        modulo = "Grupos Newsletter"

        def importar(self):
            super(NewsletterGroups, self).importar()
            self.cur.execute('SELECT * FROM newsletter_grupos ORDER BY codigo')
            self.startCounter()
            for row in self.cur:
                print '%s/%s' % (self.plusCounter(), self.cur.rowcount)
                tmp = MODnewsletter.Group.objects.create(
                                                         title = row['titulo'],
                                                         id = row['codigo']
                                                         )
            print 'OK'

    class NewsletterGroupsGROUPS(IMPORTSIM4):
        modulo = "Grupos Newsletter Grupos"

        def importar(self):
            super(NewsletterGroupsGROUPS, self).importar()
            self.cur.execute('SELECT * FROM newsletter_grupos_newsletter')
            self.startCounter()
            for row in self.cur:
                print '%s/%s' % (self.plusCounter(), self.cur.rowcount)
                tmp = MODnewsletter.NewsletterGroup.objects.create(
                                                         newsletter = row['newsletter'],
                                                         group = row['grupo']
                                                         )
            print 'OK'

    class Users(IMPORTSIM4):
        modulo = "Utilizadores"

        def importar(self):
            super(Users, self).importar()
            self.cur.execute('SELECT * FROM newsletter_utilizadores WHERE email NOT LIKE \'\' ORDER BY codigo')
            self.startCounter()
            for row in self.cur:
                print '%s/%s' % (self.plusCounter(), self.cur.rowcount)
                try:
                    tmp = MODnewsletter.User.objects.create(
                                                        email = row['email'],
                                                        aproved = True if row['aprovada']==1 else False,
                                                        id = row['codigo']
                                                        )
                except:
                    self.counter -= 1
            print 'OK'

    class UsersGROUPS(IMPORTSIM4):
        modulo = "Grupos Utilizadores"

        def importar(self):
            super(UsersGROUPS, self).importar()
            self.cur.execute('SELECT * FROM newsletter_utilizadores_grupos ORDER BY codigo')
            self.startCounter()
            for row in self.cur:
                print '%s/%s' % (self.plusCounter(), self.cur.rowcount)
                tmp = MODnewsletter.UserGroup.objects.create(
                                                         user = row['codigo_utilizador'],
                                                         group = row['codigo_grupo']
                                                         )
            print 'OK'
