#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.db.models import Q
from django.template import Context, Template
from peakitcms.funcionalidades.Mailer import Mailer
from django.conf import settings as django_settings

from feincms.models import Base
from inline_ordering.models import Orderable

from newsletter import options as OPTnewsletter
from conteudos import models as Mconteudos
from peakitcms.conteudos.templates.models import getBaseTemplate
#from website.models import WebSite

from django.db.models import get_model

from datetime import datetime, timedelta
import sys
#import tempfile
from sorl.thumbnail import get_thumbnail


class User(Base):
    #website = models.ForeignKey(WebSite)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='newsletters_users_website', default=1)
    aproved = models.BooleanField(_(u'aprovado'), default=False)
    email = models.EmailField(_(u'email'))#, unique=True
    aprove_key = models.CharField(_(u'key'), max_length=255, null=True,
        blank=True)
    groups = models.ManyToManyField('Group', through='UserGroup',
        related_name='newsletters_users_groups', null=True, blank=True)

    def __unicode__(self):
        return self.email

    class Meta:
        verbose_name = _(u'utilizador')
        verbose_name_plural = _(u'utilizadores')
        unique_together = ('website', 'email')


class Group(Base):
    #website = models.ForeignKey(WebSite)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='newsletters_groups_website', default=1)
    ref = models.CharField(_(u'referência'), max_length=255, null=True,
        blank=True)
    active = models.BooleanField(_(u'activo'), default=True)
    title = models.CharField(_(u'título'), max_length=255)

    def __unicode__(self):
        return self.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')


class UserGroup(Base):
    user = models.ForeignKey(User, verbose_name=_(u'utilizador'),
        related_name='newsletters_usergroups_user', db_index=True)
    group = models.ForeignKey(Group, verbose_name=_(u'grupo'),
        related_name='newsletters_usergroups_group', db_index=True)

    def __unicode__(self):
        return self.group.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')
        unique_together = (("user", "group"),)


class Newsletter(Base):
    #website = models.ForeignKey(WebSite)
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='newsletters_newsletters_website', default=1)
    ref = models.CharField(_(u'referência'), max_length=255, null=True,
        blank=True)
    title = models.CharField(_(u'título'), max_length=255)
    active = models.BooleanField(_(u'activa'), default=False)
    subject = models.CharField(_(u'assunto'), max_length=255)
    body = models.TextField(_(u'corpo'))
    ntype = models.IntegerField(_('tipo'), choices=OPTnewsletter.TYPES,
        default=1)
    start_date = models.DateTimeField(_(u'ínicio'), blank=True, null=True,
        db_index=True)
    last_sended = models.DateTimeField(_(u'enviada'), blank=True, null=True,
        db_index=True)
    send_news = models.BooleanField(_(u'enviar notícias'), default=False)
    send_news_number = models.IntegerField(_(u'número de notícias'),
        blank=True, null=True)
    send_pdf_destaque = models.BooleanField(_(u'enviar destaque pdf'),
        default=False)
    sections = models.ManyToManyField('conteudos.Seccao',
        through='NewsletterSection', related_name='newsletters_newsletters_sections',
        null=True, blank=True)
    groups = models.ManyToManyField('Group', through='NewsletterGroup',
        related_name='newsletters_newsletters_groups', null=True, blank=True)

    def __unicode__(self):
        return self.title

    """
    Envia emails na nossa quee
    """
    def dispatch_quee(self):
        if self.debug:
            sys.stdout.write('Iniciar dispatch_quee\n')

        queue = Quee.objects.all()[:getattr(django_settings,
            'NEWSLETTER_MAX_TO_DISPATCH', 500)]
        queue = Quee.objects.all(
            )[:django_settings.NEWSLETTER_MAX_TO_DISPATCH]
        for e in queue:
            mailer = Mailer(e.from_mail, e.to_mail, e.subject, e.body)
            if mailer.send() or e.trys == 3:
                e.delete()
            else:
                e.trys += 1
                e.save()

        if self.debug:
            sys.stdout.write('Fim dispatch_quee\n')

    def ok_newsletter(self, n):
        if n.last_sended is None: #Não interessa o tipo, se nunca mandou vai mandar
            return True
        dia_enviada = datetime(n.last_sended.year, n.last_sended.month,
            n.last_sended.day, n.start_date.hour, n.start_date.minute,
            n.start_date.second)
        hoje = datetime.today()
        if n.ntype == 1:  # Diária
            z = datetime.now() - dia_enviada
            if z.days > 0:
                return True
        if n.ntype == 2:  # Semanal
            if dia_enviada <= hoje + timedelta(days=-7):
                return True
        if n.ntype == 3:  # Mensal
            if dia_enviada <= hoje + timedelta(days=-30):
                return True
        if n.ntype == 4:  # Anual
            if dia_enviada <= hoje + timedelta(days=-365):
                return True
        return False

    def get_users(self, n):
        if self.debug:
            sys.stdout.write("Getting users:\n")

        users = []
        for e in n.newsletters_newsletterusers_newsletter.filter(
            user__aproved=True).values('user__email'):
            if self.debug:
                sys.stdout.write(u'.')
            users += [e['user__email'], ]

        if self.debug:
            sys.stdout.write(u'Completed\n')

        return users

    def get_users_groups(self, n):
        if self.debug:
            sys.stdout.write("Getting users groups:\n")

        groups = []
        for e in n.newsletters_newslettergroups_newsletter.filter(
            group__active=True, group__newsletters_users_groups__aproved=True
            ).values('group__newsletters_users_groups__email'):
                if self.debug:
                    sys.stdout.write(u'.')
                groups += [e['group__newsletters_users_groups__email'], ]

        if self.debug:
            sys.stdout.write("Completed\n")

        return groups

    def construct_newsletter(self, n):
        if self.debug:
            sys.stdout.write("Contruct newsletter:\n")

        mail_context = {}
        template = Template(n.body)
        agora = datetime.now()
        tags = dict()
        for new in n.newsletters_newsletternews_newsletter.all():
            if new.tag not in tags:
                tags[new.tag] = []
                try:
                    get_thumbnail(new.news.capa, '120', crop='center', quality=99)
                except Exception, e:
                    #print e
                    pass

            tags[new.tag] += [new.news, ]
        mail_context = {
            'meses': self.get_months(),
            'data': {
                'dia': agora.day,
                'mes': agora.month,
                'ano': agora.year,
                'mes_extenso': self.get_months()[agora.month]
                },
            }
        for k in tags.iterkeys():
            mail_context[k
            ] = '{%% include "noticia_listagem.html" with tag=tags.%(tag)s STATIC_URL="%(static_url)s" MEDIA_ROOT="%(media_root)s" %%}' % {'tag':k, 'static_url':getattr(django_settings,'STATIC_URL'), 'media_root':getattr(django_settings,'MEDIA_ROOT')}

        ftemplate = Template(template.render(Context(mail_context)))

        if self.debug:
            sys.stdout.write("Completed\n")

        return ftemplate.render(Context({'tags': tags}))

    def get_months(self):
        return {
            1: u'Janeiro',
            2: u'Fevereiro',
            3: u'Março',
            4: u'Abril',
            5: u'Maio',
            6: u'Junho',
            7: u'Julho',
            8: u'Agosto',
            9: u'Setembro',
            10: u'Outubro',
            11: u'Novembro',
            12: u'Dezembro'
            }

    def get_newsletters(self):
        if self.debug:
            sys.stdout.write("Getting newsletters:\n")

        newsletters = []
        tmp = self.__class__.objects.filter(Q(active=True),
            Q(start_date__lte=datetime.now()))#[:50]
        for n in tmp:
            if self.ok_newsletter(n):
                tmp_users = []
                tmp_users += self.get_users(n)
                tmp_users += self.get_users_groups(n)
                newsletters += [{
                        'emails': list(set(tmp_users)),
                        'body': self.construct_newsletter(n).replace('"/media/', '"http://www.diocese-braga.pt/media/'),
                        'n': n
                    }, ]

        if self.debug:
            sys.stdout.write("Completed\n")

        return newsletters

    """
    Adiciona todas as newsletter à queue
    """
    def add_quee(self):
        if self.debug:
            sys.stdout.write("Iniciar add_quee:\n")
        for en in self.get_newsletters():
            n = en['n']
            for e in en['emails']:
                mailer = Mailer(getattr(django_settings,
                    'NEWSLETTER_FROM_EMAIL'), e, n.subject, en['body'])
                #mailer.dispatcher = getattr(django_settings,
                #    'NEWSLETTER_DISPATCHER', 'self')
                mailer.queue = Quee
                mailer.send()
            n.last_sended = datetime.now()
            n.save()

        if self.debug:
            sys.stdout.write("Completed\n")

    """
    Trata de decidir o que fazer conforme o que recebe na consola
    """
    def handler(self, *args):
        self.debug = False
        if 'add_queue' in args:
            print datetime.now()
            self.add_quee()
        else:
            if 'dispatch_queue' in args:
                #print datetime.now()
                self.dispatch_quee()


class NewsletterSection(Base):
    newsletter = models.ForeignKey(Newsletter, verbose_name=_(u'newsletter'),
        related_name='newsletters_newslettersections_newsletter', db_index=True)
    section = models.ForeignKey('conteudos.Seccao', verbose_name=_(u'secção'),
        related_name='newsletters_newslettersections_section', db_index=True)

    def __unicode__(self):
        return self.section.title

    class Meta:
        verbose_name = _(u'secção')
        verbose_name_plural = _(u'secções')
        unique_together = (("newsletter", "section"),)


class NewsletterGroup(Base):
    newsletter = models.ForeignKey(Newsletter, verbose_name=_(u'newsletter'),
        related_name='newsletters_newslettergroups_newsletter', db_index=True)
    group = models.ForeignKey(Group, verbose_name=_(u'grupo'),
        related_name='newsletters_newslettergroups_group', db_index=True)

    def __unicode__(self):
        return self.group.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')
        unique_together = (("newsletter", "group"),)


class NewsletterUser(Base):
    newsletter = models.ForeignKey(Newsletter, verbose_name=_(u'newsletter'),
        related_name='newsletters_newsletterusers_newsletter', db_index=True)
    user = models.ForeignKey(User, verbose_name=_(u'user'),
        related_name='newsletters_newsletterusers_user', db_index=True)

    class Meta:
        verbose_name = _(u'user')
        verbose_name_plural = _(u'user')
        unique_together = (("newsletter", "user"),)

    def __unicode__(self):
        return str(self.user)


class NewsletterNew(Base, Orderable):
    newsletter = models.ForeignKey(Newsletter, verbose_name=_(u'newsletter'),
        related_name='newsletters_newsletternews_newsletter', db_index=True)
    news = models.ForeignKey(Mconteudos.Noticia, verbose_name=_(u'noticia'),
        related_name='newsletters_newsletternews_news', db_index=True)
    tag = models.CharField(_(u'tag'), max_length=255)

    class Meta(Orderable.Meta):
        verbose_name = _(u'noticia')
        verbose_name_plural = _(u'noticias')

    def __unicode__(self):
        return self.news.titulo


class NewsletterTemplate(getBaseTemplate()):
    pass


class NewsletterTemplateTag(models.Model):
    template = models.ForeignKey(NewsletterTemplate)
    tag = models.CharField(_(u'tag'), max_length=255)

    class Meta:
        verbose_name_plural = _(u'Tags disponíveis')
        unique_together = ('template', 'tag')

    def __unicode__(self):
        return self.tag


class Quee(Base):
    from_mail = models.EmailField(_(u'de'))
    to_mail = models.EmailField(_(u'para'))
    subject = models.CharField(_(u'assunto'), max_length=255)
    body = models.TextField(_(u'corpo'))
    data = models.DateTimeField(_(u'data'), default=datetime.now())
    trys = models.IntegerField(_(u'tentativas'), default=0)

    def __unicode__(self):
        return self.subject

    class Meta:
        verbose_name = _(u'quee')
        verbose_name_plural = _(u'quees')
