#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline, OrderableTabularInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget


# Models
def getBaseAgenda(baseagendaentidade, baseagendalocal):
    class BaseAgenda(Base):
        titulo = models.CharField(max_length=255)
        descricao = models.TextField(_(u'Descrição'), null=True, blank=True)
        entidade = models.ForeignKey(baseagendaentidade, verbose_name=_(u'Entidade'), related_name='%(app_label)s_%(class)s_entidade', null=True, blank=True)
        local = models.ForeignKey(baseagendalocal, verbose_name=_(u'Local'), related_name='%(app_label)s_%(class)s_local', null=True, blank=True)
        data_inicio = models.DateTimeField(_(u'Hora Início'))
        data_fim = models.DateTimeField(_(u'Hora Saída'))

        class Meta:
            abstract = True
            verbose_name = u'agenda'
            verbose_name_plural = u'agendas'

        def __unicode__(self):
            return self.titulo

    return BaseAgenda

# Fim Models

# Admin
def getBaseAgendaForm(mymodel):
    class BaseAgendaForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseAgendaForm

def getBaseAgendaAdmin(mymodel):
    class BaseAgendaAdmin(getBaseAdmin(mymodel)):
        form =  getBaseAgendaForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       'data_inicio',
                                       'data_fim',
                                       'descricao',
                                       'entidade',
                                       'local',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'resumo', 'id', )

    return BaseAgendaAdmin
# Fim Admin
