#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseAgendaLocal():
    class BaseAgendaLocal(Base):
        titulo = models.CharField(max_length=255)

        class Meta:
            abstract = True
            verbose_name = u'agenda local'
            verbose_name_plural = u'agenda locais'

        def __unicode__(self):
            return self.titulo

    return BaseAgendaLocal
# Fim Models

# Admin
def getBaseAgendaLocalForm(mymodel):
    class BaseAgendaLocalForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseAgendaLocalForm

def getBaseAgendaLocalAdmin(mymodel):
    class BaseAgendaLocalAdmin(getBaseAdmin(mymodel)):
        form =  getBaseAgendaLocalForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'resumo', 'id', )

    return BaseAgendaLocalAdmin
# Fim Admin
