#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseImagem():
    class BaseImagem(Base):
        titulo = models.CharField(max_length=255)
        imagem = models.CharField(max_length=255, null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'imagem'
            verbose_name_plural = u'imagens'

        def __unicode__(self):
            return self.titulo
    return BaseImagem
# Fim Models

# Admin
def getBaseImagemAdmin(mymodel):
    class BaseImagemForm(BaseForm):
        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'imagem': ElfinderImageWidget(attrs={'a':'a'}),
            }

    class BaseImagemAdmin(getBaseAdmin(mymodel)):
        form = BaseImagemForm
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       ('imagem', 'fs'),
                                       'titulo'
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseImagemAdmin
# Fim Admin
