#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _


from datetime import datetime
from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm
from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable


# Models -----------------------
def getBaseInquerito():
    class BaseInquerito(Base):
        titulo = models.CharField(_(u'título'), max_length=255)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'inquérito'
            verbose_name_plural = u'inquéritos'

        def __unicode__(self):
            return self.titulo

    return BaseInquerito

def getBaseOpcao(baseinquerito):
    class BaseOpcao(Orderable):
        inquerito = models.ForeignKey(baseinquerito)
        opcao = models.CharField(_(u'nome'), max_length=100)
        votos = models.IntegerField(_(u'votos'), default=0)

        class Meta(Orderable.Meta):
            verbose_name = _(u'inquérito')
            verbose_name_plural = _(u'inquéritos')
            abstract = True

        def __unicode__(self):
            return self.opcao
    return BaseOpcao

def getBaseOpcaoInfo(baseopcao):
    class BaseOpcaoInfo(models.Model):
        opcao = models.ForeignKey(baseopcao)
        ip = models.CharField(_(u'ip'), max_length=30)
        data = models.DateTimeField(default=datetime.now)
        sessao = models.CharField(_(u'session'), max_length=255,null=True,blank=True)

        class Meta:
            verbose_name = _(u'opção')
            verbose_name_plural = _(u'opções')
            abstract = True
    return BaseOpcaoInfo
# --------------------------------

# Admin --------------------------

def getBaseOpcaoInline(baseopcao):
    class BaseOpcaoInline(OrderableStackedInline):
        model = baseopcao
        extra=2

        class Media:
            js = ('admin/js/jquery-ui.min.js', 'inline_ordering.js', 'admin/inqueritos_defeito.js',)

    return BaseOpcaoInline


def getBaseInqueritoAdmin(mymodel):
    class BaseInqueritoForm(BaseForm):
        class Meta:
            model = mymodel

    class BaseInqueritoAdmin(getBaseAdmin(mymodel)):
        form =  BaseInqueritoForm
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseInqueritoAdmin
# --------------------------------
