#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm
#from peakitcms.conteudos.seccoes.models import BaseSeccao
from peakitcms.conteudos.filters import ParentFieldListFilter

#from tinymce import widgets as tinymce_widgets
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget
from redactor.widgets import JQueryEditor as RedactorEditor


# Models -----------------------
def getBaseNoticia(baseseccao, noticia_seccao, basenoticia, noticia_noticia):
    class BaseNoticia(Base):
        ante_titulo = models.CharField(max_length=255, null=True, blank=True)
        titulo = models.CharField(max_length=255)
        pos_titulo = models.CharField(max_length=255, null=True, blank=True)
        resumo = models.TextField(null=True, blank=True)
        noticia = models.TextField()
        autor = models.CharField(max_length=255, null=True, blank=True)
        restrito = models.BooleanField(default=True)
        aceitar_comentarios = models.IntegerField(choices=((1,u'Não'),(2,u'Sim'),(3,u'Sim Automáticos')), default=1)
        capa = models.CharField(max_length=255, null=True, blank=True)
        autor_capa = models.CharField(max_length=255, null=True, blank=True)

        seccoes = models.ManyToManyField(baseseccao, through=noticia_seccao, related_name='%(app_label)s_%(class)s_noticia_seccao', null=True, blank=True)
        seccoes.arvore_filter = True
        relacoes = models.ManyToManyField(basenoticia, through=noticia_noticia, related_name='%(app_label)s_%(class)s_noticia_relacao', null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = u'notícia'
            verbose_name_plural = u'notícias'

        def __unicode__(self):
            return self.titulo

        #def getList(self):
        #    return self.__class__.objects.only('titulo', 'aprovado_por', 'alterado' ,'id').extra(select={'tipo_conteudo':'\'noticia\''})

    return BaseNoticia

def getBaseNoticiaSeccao(basenoticia, baseseccao):
    class BaseNoticiaSeccao(models.Model):
        noticia = models.ForeignKey(basenoticia, verbose_name=_(u'secção'), related_name='%(app_label)s_%(class)s_noticia')
        seccao = models.ForeignKey(baseseccao, verbose_name=_(u'secção'), related_name='%(app_label)s_%(class)s_seccao')
        seccao_publicacao = models.IntegerField(_(u'secção de publicação'), choices=((1,u'Destaque Principal'),(2,u'Destaque Secundário')), null=True, blank=True)

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'secção')
            verbose_name_plural = _(u'secções')
            unique_together = (("noticia", "seccao"),)

        def __unicode__(self):
            return self.seccao.title
    return BaseNoticiaSeccao

def getBaseNoticiaRelacao(basenoticia1, basenoticia2):
    class BaseNoticiaRelacao(models.Model):
        noticia = models.ForeignKey(basenoticia1, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_ori', db_index=True)
        noticia_rel = models.ForeignKey(basenoticia2, verbose_name=_(u'notícia'), related_name='%(app_label)s_%(class)s_noticia_rel', db_index=True)

        def save(self, *args, **kwargs):
            super(BaseNoticiaRelacao, self).save(*args, **kwargs)
            self.noticia_rel.relations.through.objects.get_or_create(
                                                              noticia_id = self.noticia_rel.id,
                                                              noticia_rel_id = self.noticia.id
                                                              )

        def delete(self):
            myid = self.noticia_rel.id
            super(BaseNoticiaRelacao, self).delete()
            try:
                d = self.noticia_rel.relations.through.objects.get(noticia__id=myid)
                d.delete()
            except:
                pass

        #def __unicode__(self):
        #    return self.noticia_rel.titulo

        class Meta:
            abstract = True
            verbose_name = _(u'relacionado')
            verbose_name_plural = _(u'relacionados')
            unique_together = (("noticia", "noticia_rel"),)
    return BaseNoticiaRelacao

# Admin --------------------------
def getBaseSeccaoInline(mymodel, seccao='seccao'):
    class BaseSeccaoInline(admin.TabularInline):
        extra = 0
        model = mymodel
        raw_id_fields = ('seccao',)
    return BaseSeccaoInline

def getBaseNoticiaInline(mymodel):
    class BaseNoticiaInline(admin.TabularInline):
        extra = 0
        model = mymodel
        fk_name= 'noticia'
        raw_id_fields = ('noticia_rel',)
    return BaseNoticiaInline

def getBaseNoticiaForm(mymodel):
    class BaseNoticiaForm(BaseForm):
        #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
        noticia = forms.CharField(widget=RedactorEditor())
        class Meta:
            model = mymodel
            widgets = {
                'fs': forms.widgets.HiddenInput,
                'capa': ElfinderImageWidget(attrs={'a':'a'}),
            }
    return BaseNoticiaForm

def getBaseNoticiaAdmin(mymodel):
    class BaseNoticiaAdmin(getBaseAdmin(mymodel)):
        form =  getBaseNoticiaForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                                         'fields':(
                                                   ('restrito', 'aceitar_comentarios'),
                                                   )
                                         }),
                     (None, {
                             'fields':(
                                       ('ante_titulo', 'titulo', 'pos_titulo'),
                                       'resumo',
                                       'noticia',
                                       'autor',
                                       )
                             }),
                     (_(u'Capa'), {
                             'fields':(
                                       ('capa', 'fs'),
                                       'autor_capa',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', 'seccoes' )
        search_fields = ('titulo', 'resumo', 'noticia', 'id', )

    return BaseNoticiaAdmin
# --------------------------------
