#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from tinymce import widgets as tinymce_widgets

# Models
def getBaseTemplate():
    class BaseTemplate(Base):
        ref = models.CharField(_(u'referência'), max_length=255, blank=True, null=True, db_index=True)
        titulo = models.CharField(_(u'título'), max_length=80)
        template = models.TextField(_(u'ficheiro'))

        class Meta:
            abstract = True
            verbose_name = u'template'
            verbose_name_plural = u'templates'

        def __unicode__(self):
            return self.titulo
    return BaseTemplate

def getBaseEmailTemplate():
    class BaseEmailTemplate(getBaseTemplate()):
        de_email = models.EmailField(_(u'de email'), null=True, blank=True)
        para_email = models.EmailField(_(u'para email'), null=True, blank=True)
        assunto = models.CharField(_(u'assunto'), max_length=255)

        class Meta:
            abstract = True
            verbose_name = u'template'
            verbose_name_plural = u'templates'

        def __unicode__(self):
            return self.titulo

    return BaseEmailTemplate
# Fim Models

# Admin
def getBaseTemplateForm(mymodel):
    class BaseTemplateForm(BaseForm):
        #template = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
        class Meta:
            model = mymodel
    return BaseTemplateForm

def getBaseTemplateAdmin(mymodel):
    class BaseTemplateAdmin(getBaseAdmin(mymodel)):
        form =  getBaseTemplateForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'ref',
                                       'titulo',
                                       'template',
                                       )
                             }),
                     )
        list_display = ('titulo', 'ref', 'activo', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('ref', 'titulo', 'id', )

    return BaseTemplateAdmin

def getBaseEmailTemplateAdmin(mymodel):
    class BaseEmailTemplateAdmin(getBaseAdmin(mymodel)):
        form =  getBaseTemplateForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     (None, {
                             'fields':(
                                       'ref',
                                       'titulo',
                                       ('de_email', 'para_email'),
                                       'assunto',
                                       'template',
                                       )
                             }),
                     )
        list_display = ('titulo', 'ref', 'activo', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('ref', 'titulo', 'id', )

    return BaseEmailTemplateAdmin
# Fim Admin
