#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.conteudos.models import getBaseAdmin

from datetime import datetime

# Models
def getBaseQueue():
    class BaseQueue(models.Model):
        de_email = models.EmailField(_(u'de'))
        para_email = models.EmailField(_(u'para'))
        assunto = models.CharField(_(u'assunto'), max_length=255)
        corpo = models.TextField(_(u'corpo'))
        data = models.DateTimeField(u'data', default=datetime.now())
        tentativas = models.IntegerField(_(u'tentativas'), default=0)
        
        class Meta:
            abstract = True
        
        def __unicode__(self):
            return self.assunto

    return BaseQueue
# Fim Models

# Admin
def getBaseQueueAdmin(mymodel):
    class QueueAdmin(admin.ModelAdmin):
        save_on_top = True
        list_display = ('de_email', 'para_email', 'assunto', 'tentativas', 'data', 'id',)
        search_fields = ('id', 'de_email', 'para_email', 'assunto', 'corpo' )
    return QueueAdmin
# Fim Admin