#coding: utf-8
from django.core import mail


class Mailer(object):
    dispatcher = None
    queue = None

    def __init__(self, from_email, to_email, subject, body):
        self.set(from_email, to_email, subject, body)

    def set(self, from_email, to_email, subject, body):
        self.from_email = from_email
        self.to_email = to_email
        self.subject = subject
        self.body = body

    def send(self):
        if self.dispatcher is None:
            email = mail.EmailMultiAlternatives(self.subject, self.body,
                self.from_email, [self.to_email])
            email.attach_alternative(self.body, 'text/html')
            return email.send(fail_silently=False)
        else:
            if self.dispatcher == 'self':
                if self.queue is None:
                    raise Exception('O parametro queue não está definido')

                return self.queue.objects.create(
                                          from_mail=self.from_email,
                                          to_mail=self.to_email,
                                          subject=self.subject,
                                          body=self.body
                                          )
