#coding: utf-8
from django.views.generic import DetailView, ListView
from django.views.generic.edit import FormView
from django.conf import settings as django_settings
from django.db.models import Q

"""
Class que retorna uma FormView com um template no objecto object_template.
Esta view tem de implementar o seguinte:
    form_class = FormView,
    sucess_url = '/sucess',
    template_name = 'ficheiro_template.html'
"""
def getBaseTemplateFormView(class_objecto, slug):
    class BaseTemplateFormView(FormView):
        def get_context_data(self, **kwargs):
            from django.template import Context, Template
            context = super(BaseTemplateFormView, self).get_context_data(**kwargs)
            objecto = class_objecto.objects.get(ref=slug)
            context['object_template'] = objecto
            
            template = Template('{% load thumbnail %}' + objecto.template)
            
            context['object_template_template'] = template.render(Context({
                                                                      'STATIC_URL':django_settings.STATIC_URL,
                                                                      'MEDIA_URL':django_settings.MEDIA_URL
                                                                      }))
            return context
    return BaseTemplateFormView

def getBaseDetailView():
    class BaseDetailView(DetailView):
        def get_context_data(self, **kwargs):
            from django.template import Context, Template
            context = super(BaseDetailView, self).get_context_data(**kwargs)
            
            template = Template('{% load thumbnail %}'+self.object.template)
            
            context['object_template'] = template.render(Context({
                                                                      'STATIC_URL':django_settings.STATIC_URL,
                                                                      'MEDIA_URL':django_settings.MEDIA_URL
                                                                      }))
            return context
    return BaseDetailView

def getBaseDetailTemplateView(class_objecto, slug):
    class BaseDetailTemplateView(DetailView):
        def get_context_data(self, **kwargs):
            from django.template import Context, Template
            context = super(BaseDetailTemplateView, self).get_context_data(**kwargs)
            objecto = class_objecto.objects.get(ref=slug)
            context['object_template'] = objecto 
            return context
    return BaseDetailTemplateView

def getBaseFotogaleriaListView(class_objecto, slug):
    class BaseFotogaleriaListView(ListView):
        def get_queryset(self):
            qs = super(BaseFotogaleriaListView, self).get_queryset()
            qs = qs.filter(Q(ref__isnull=True) | Q(ref__exact=''))
            return qs
            
        def __init__(self, **kwargs):
            super(BaseFotogaleriaListView, self).__init__(**kwargs)
            
        def get_context_data(self, **kwargs):
            from django.template import Context, Template
            context = super(BaseFotogaleriaListView, self).get_context_data(**kwargs)
            objecto = class_objecto.objects.get(ref=slug)
            x = context
            x['object'] = objecto
            x['STATIC_URL'] = django_settings.STATIC_URL
            x['MEDIA_URL'] = django_settings.MEDIA_URL
            context = x
            """
            template = Template('{% load thumbnail %}'+objecto.template)
            context['object'] = {
                                 'template': template.render(Context(x)),
                                 }
            """
            return context
    return BaseFotogaleriaListView

def getBaseListView(class_objecto, slug):
    class BaseListView(ListView):
        def get_queryset(self):
            qs = super(BaseListView, self).get_queryset()
            return qs
            
        def __init__(self, **kwargs):
            super(BaseListView, self).__init__(**kwargs)
            
        def get_context_data(self, **kwargs):
            from django.template import Context, Template
            context = super(BaseListView, self).get_context_data(**kwargs)
            objecto = class_objecto.objects.get(ref=slug)
            x = context
            x['object'] = objecto
            x['STATIC_URL'] = django_settings.STATIC_URL
            x['MEDIA_URL'] = django_settings.MEDIA_URL
            context = x
            """
            template = Template('{% load thumbnail %}'+objecto.template)
            context['object'] = {
                                 'template': template.render(Context(x)),
                                 }
            """
            return context
    return BaseListView
