#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline, OrderableTabularInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget


DIA_SEMANA_CHOICES=(
    (1, _(u'Dias Úteis - de 2ª a Sábado de Manhã')),
    (6, _(u'Sabado - Sábados de Tarde e Vésperas de Dias Festivos')),
    (7, _(u'Domingo - Domingos e Dias Festivos')),
)

# Models
def getBaseHorario():
    class BaseHorario(Base):
        titulo = models.CharField(max_length=255)

        def get_actividades(self):
            try:
                actividades = {}
                """
                dia_semana=0
                dia_semana_actividades=[]
                actividadesi=0
                actividadesall=self.horario_horarioactividades_horario.all()
                """

                
                for actividade in self.horario_horarioactividades_horario.all():
                    if actividade.dia_semana not in actividades:
                        actividades[actividade.dia_semana] = {'dia_semana':unicode(actividade.get_dia_semana()),'actividades':[]}
                    actividades[actividade.dia_semana]['actividades'].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})



                """


                for actividade in actividadesall:
                    if actividade.get_dia_semana() not in actividades:
                        actividades[unicode(actividade.get_dia_semana())] = []
                    actividades[unicode(actividade.get_dia_semana())].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})
                """

                """
                for actividade in actividadesall:

                    actividadesi+=1

                    if not dia_semana==actividade.dia_semana:

                        if not dia_semana_actividades==[]:
                            actividades.append({'dia_semana':actividade.get_dia_semana(), 'actividades':dia_semana_actividades})   
                        dia_semana_actividades=[]
                        dia_semana=actividade.dia_semana

                    else:   
                        dia_semana_actividades.append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})

                    if len(actividadesall)==actividadesi:
                        actividades.append({'dia_semana':actividade.get_dia_semana(), 'actividades':dia_semana_actividades})  
                """


                """   
                actividades = {}             
                for actividade in self.horario_horarioactividades_horario.all():
                    if actividade.dia_semana not in actividades:
                        actividades[actividade.dia_semana] = {'dia_semana':unicode(actividade.get_dia_semana()),'actividades':[]}
                    actividades[actividade.dia_semana]['actividades'].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})

                """
                actividades = {}
                try:
                    #actividadeactual=''
                    for actividade in self.horario_horarioactividades_horario.order_by('dia_semana', 'hora_entrada', 'local__titulo').all():
                        
                        """
                        if actividade.dia_semana not in actividades:
                            actividades[actividade.dia_semana] = {'dia_semana':unicode(actividade.get_dia_semana()),'actividades':[]}
                        #actividades[actividade.dia_semana]['actividades'].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})

                        """

                        """
                        from django.utils.datastructures import SortedDict


                        hora=int(str(actividade.hora_entrada)[:-3].replace(':',''))
                        hora=str(hora)#+'L'
                        print hora
                        print '-------------------------->0'
                        if actividade.dia_semana not in actividades:
                            print '-------------------------->0.1'
                            actividades[actividade.dia_semana]={}
                        print '-------------------------->1'
                        if actividade.dia_semana not in actividades or hora not in actividades[actividade.dia_semana]:
                            print '-------------------------->2'
                            actividades[actividade.dia_semana][hora] = {'dia_semana':unicode(actividade.get_dia_semana()), 'actividades':[]}
                            print '-------------------------->2.1'
                            actividades[actividade.dia_semana][hora]['actividades'].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})
                            print '-------------------------->3'
                            #actividades[actividade.dia_semana][hora]['actividades']=sorted(actividades[actividade.dia_semana][hora]['actividades'])
                            
                            #sort_dict = [x for x in actividades[actividade.dia_semana].iteritems()]
                            #sort_dict = [x for x in messy_dict.iteritems()]
                            #sort_dict.sort(key=lambda x: x[0]) # sort by key
                            #print sort_dict
                            #print dict(sort_dict)
                            print '-------------------------->3'

                        """
                        """
                        if actividade.dia_semana not in actividades:
                            actividades[actividade.dia_semana] = {'dia_semana':unicode(actividade.get_dia_semana()),'actividades':[]}
                        actividades[actividade.dia_semana]['actividades'].append({'hora_entrada':actividade.hora_entrada, 'local':actividade.local})

                        """



                        if actividade.dia_semana not in actividades:
                            actividades[actividade.dia_semana] = {'dia_semana':unicode(actividade.get_dia_semana()),'actividades':{}}

                        #hora=str(actividade.hora_entrada)[:-3]+'L'
                        
                        hora=actividade.hora_entrada.hour*60+actividade.hora_entrada.minute
                        if hora not in actividades[actividade.dia_semana]['actividades']:
                            actividades[actividade.dia_semana]['actividades'][hora]={}

                        #actividades[actividade.dia_semana]['actividades'][hora].append({'local':actividade.local, 'tipo':(actividade.tipo.abreviatura if actividade.tipo else None)})
                        #actividades[actividade.dia_semana]['actividades'][hora][actividade.local.titulo].append({'tipo':(actividade.tipo.abreviatura if actividade.tipo else None)})
                        if actividade.local.titulo not in actividades[actividade.dia_semana]['actividades'][hora]:
                            actividades[actividade.dia_semana]['actividades'][hora][actividade.local.titulo]=[]

                        if actividade.tipo:
                            actividades[actividade.dia_semana]['actividades'][hora][actividade.local.titulo].append({'tipo':(actividade.tipo.abreviatura if actividade.tipo else None)})
                        #actividadeactual=actividade.dia_semana+str('actividades')+hora+[actividade.local.titulo

                except Exception, e:
                    #print e
                    pass

                #print actividades
                return actividades
            except Exception, e:
                #print e
                #pass
                return []

        class Meta:
            abstract = True
            verbose_name = u'horário'
            verbose_name_plural = u'horários'

        def __unicode__(self):
            return self.titulo

    return BaseHorario

def getBaseHorarioActividades(basehorario, basehorariotipo, basehorariolocal):
    class BaseHorarioActividades(models.Model):
        horario = models.ForeignKey(basehorario, verbose_name=_(u'Horário'), related_name='%(app_label)s_%(class)s_horario')
        tipo = models.ForeignKey(basehorariotipo, verbose_name=_(u'Tipo'), related_name='%(app_label)s_%(class)s_tipo', null=True, blank=True)
        local = models.ForeignKey(basehorariolocal, verbose_name=_(u'Local'), related_name='%(app_label)s_%(class)s_local')#, null=True, blank=True
        hora_entrada = models.TimeField(_(u'Hora Entrada'))#, null=True, blank=True
        hora_saida = models.TimeField(_(u'Hora Saída'), null=True, blank=True)
        dia_semana = models.PositiveIntegerField(_(u'Dia Semana'), max_length=1, choices=DIA_SEMANA_CHOICES, default=1)

        def get_dia_semana(self):
            try:
                return dict(DIA_SEMANA_CHOICES)[self.dia_semana]
            except Exception, e:
                #pass
                return None

        class Meta(Base.Meta):
            abstract = True
            verbose_name = _(u'actividade')
            verbose_name_plural = _(u'actividades')
            unique_together = ('horario', 'tipo', 'local', 'hora_entrada','hora_saida','dia_semana',)
            ordering = ['dia_semana', 'hora_entrada', 'local__titulo']

        def __unicode__(self):
            """
            try:
                actividade = self.horario.titulo+' - '+self.tipo.titulo+' - '+self.local.titulo
            except Exception, e:
                actividade=''
            return actividade
            """
            return ''
    return BaseHorarioActividades

# Fim Models

# Admin
def getBaseHorarioActividadeInline(mymodel):
    class BaseHorarioActividadeInline(admin.TabularInline):
        model = mymodel
        extra=0
        raw_id_fields = ('horario','tipo', 'local',)

    return BaseHorarioActividadeInline

def getBaseHorarioForm(mymodel):
    class BaseHorarioForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseHorarioForm

def getBaseHorarioAdmin(mymodel):
    class BaseHorarioAdmin(getBaseAdmin(mymodel)):
        form =  getBaseHorarioForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseHorarioAdmin
# Fim Admin
