#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseHorarioLocal():
    class BaseHorarioLocal(Base):
        titulo = models.CharField(max_length=255)

        class Meta:
            abstract = True
            verbose_name = u'horário local'
            verbose_name_plural = u'horário locais'

        def __unicode__(self):
            return self.titulo

    return BaseHorarioLocal
# Fim Models

# Admin
def getBaseHorarioLocalForm(mymodel):
    class BaseHorarioLocalForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseHorarioLocalForm

def getBaseHorarioLocalAdmin(mymodel):
    class BaseHorarioLocalAdmin(getBaseAdmin(mymodel)):
        form =  getBaseHorarioLocalForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseHorarioLocalAdmin
# Fim Admin
