#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseHorarioTipo():
    class BaseHorarioTipo(Base):
        titulo = models.CharField(max_length=255)
        abreviatura = models.CharField(_(u'Abreviatura'), max_length=255)#, null=True, blank=True

        class Meta:
            abstract = True
            verbose_name = u'horário tipo'
            verbose_name_plural = u'horário tipos'
            ordering = ['abreviatura', 'titulo']

        def __unicode__(self):
            return self.abreviatura +str(' - ')+ self.titulo

    return BaseHorarioTipo
# Fim Models

# Admin
def getBaseHorarioTipoForm(mymodel):
    class BaseHorarioTipoForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseHorarioTipoForm

def getBaseHorarioTipoAdmin(mymodel):
    class BaseHorarioTipoAdmin(getBaseAdmin(mymodel)):
        form =  getBaseHorarioTipoForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       'abreviatura',
                                       )
                             }),
                     )
        list_display = ('titulo', 'abreviatura', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'abreviatura', 'id', )

    return BaseHorarioTipoAdmin
# Fim Admin
