# First, define the Manager subclass.
from django.db import models

from django.db.models import Q
from datetime import datetime


class CmsDefaultManager(models.Manager):
    def get_query_set(self):
        return super(CmsDefaultManager, self).get_query_set().filter(
                    Q(activo=True),
                    Q(publicada_inicio__lte = datetime.now()),
                    (
                        Q(publicada_fim__gte = datetime.now()) |
                        Q(publicada_fim = None))
                    )
