#coding: utf-8
from django.contrib import admin
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django import forms

from peakitcms.models import Base, getBaseAdmin, DEFAULT_FIELDSETS, BaseForm

from inline_ordering.admin import OrderableStackedInline
from inline_ordering.models import Orderable
from elfinder.hooks.ElfinderImageField import ElfinderImageWidget

# Models
def getBaseNewsletterGrupo():
    class BaseNewsletterGrupo(Base):
        titulo = models.CharField(max_length=255)

        class Meta:
            abstract = True
            verbose_name = u'newsletter grupo'
            verbose_name_plural = u'newsletter grupos'

        def __unicode__(self):
            return self.titulo

    return BaseNewsletterGrupo
# Fim Models

# Admin
def getBaseNewsletterGrupoForm(mymodel):
    class BaseNewsletterGrupoForm(BaseForm):
        class Meta:
            model = mymodel

    return BaseNewsletterGrupoForm

def getBaseNewsletterGrupoAdmin(mymodel):
    class BaseNewsletterGrupoAdmin(getBaseAdmin(mymodel)):
        form =  getBaseNewsletterGrupoForm(mymodel)
        fieldsets = (
                     DEFAULT_FIELDSETS['informacao'],
                     DEFAULT_FIELDSETS['publicacao'],
                     (None, {
                             'fields':(
                                       'titulo',
                                       )
                             }),
                     )
        list_display = ('titulo', 'activo', 'aprovado_por', 'alterado', 'id',)
        list_filter = ('activo', )
        search_fields = ('titulo', 'id', )

    return BaseNewsletterGrupoAdmin
# Fim Admin
