#coding: utf-8 
from reportlab.platypus import SimpleDocTemplate
from reportlab.lib.units import inch, cm
import tempfile
from pyPdf.pdf import PdfFileWriter, PdfFileReader
from StringIO import StringIO
from reportlab.rl_config import defaultPageSize
from reportlab.lib.fonts import addMapping
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.ttfonts import TTFont
import os
from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
from reportlab.lib.enums import TA_JUSTIFY, TA_RIGHT, TA_LEFT
from reportlab.lib import colors

class MyPDF:
    _initArgs = {   'pagesize':defaultPageSize,
                    'pageTemplates':[],
                    'showBoundary':0,
                    'leftMargin':-12+1.27*cm,
                    'rightMargin':-12+1.27*cm,
                    'topMargin':-12+1.27*cm,
                    'bottomMargin':-13+1.27*cm,
                    'allowSplitting':1,
                    'title':None,
                    'author':None,
                    'subject':None,
                    'creator':None,
                    'keywords':[],
                    'invariant':None,
                    'pageCompression':None,
                    '_pageBreakQuick':1,
                    'rotation':0,
                    '_debug':0,
                    'encrypt': None,
                    'cropMarks': None,
                    'enforceColorSpace': None,
                    }
    _invalidInitArgs = ()

    def __init__(self, ficheiro_output, **kw):
        self.ficheiro_output=ficheiro_output
        
        font_folder = os.path.dirname(os.path.abspath(__file__))
        pdfmetrics.registerFont(TTFont('Calibri', '%s/%s' % (font_folder, 'fonts/calibri.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-Bold', '%s/%s' % (font_folder, 'fonts/calibrib.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-Italic', '%s/%s' % (font_folder, 'fonts/calibrii.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-BoldItalic', '%s/%s' % (font_folder, 'fonts/calibriz.ttf')))
        
        addMapping('Calibri', 0, 0, 'Calibri')
        addMapping('Calibri', 1, 0, 'Calibri-Bold')
        addMapping('Calibri', 0, 1, 'Calibri-Italic')
        addMapping('Calibri', 1, 1, 'Calibri-BoldItalic')
        
        pdfmetrics.registerFont(TTFont('Arial', '%s/%s' % (font_folder, 'fonts/arial.ttf')))
        pdfmetrics.registerFont(TTFont('Arial-Bold', '%s/%s' % (font_folder, 'fonts/arialbd.ttf')))
        pdfmetrics.registerFont(TTFont('Arial-Italic', '%s/%s' % (font_folder, 'fonts/ariali.ttf')))
        pdfmetrics.registerFont(TTFont('Arial-BoldItalic', '%s/%s' % (font_folder, 'fonts/arialbi.ttf')))
        
        addMapping('Arial', 0, 0, 'Arial')
        addMapping('Arial', 1, 0, 'Arial-Bold')
        addMapping('Arial', 0, 1, 'Arial-Italic')
        addMapping('Arial', 1, 1, 'Arial-BoldItalic')
        
        for k in self._initArgs.keys():
            if k not in kw:
                v = self._initArgs[k]
            else:
                if k in self._invalidInitArgs:
                    raise ValueError, "Invalid argument %s" % k
                v = kw[k]
            setattr(self,k,v)

        self.doc = SimpleDocTemplate(self.ficheiro_output, pagesize=self.pagesize, rightMargin=self.rightMargin,leftMargin=self.leftMargin, topMargin=self.topMargin,bottomMargin=self.bottomMargin)
        self.Story = []
        
    def getStyleSeet(self):
        stylesheet = getSampleStyleSheet()
        tamanho = 10
        tamanho_numero = 9
        stylesheet.add(ParagraphStyle(name='Calibri8', fontSize=10, fontName='Calibri', alignment=TA_JUSTIFY, firstLineIndent=0, leftIndent=0, leading=15, backColor=colors.aqua))
        stylesheet.add(ParagraphStyle(name='EtiquetasRomanRight', fontSize=tamanho_numero, fontName='Arial', alignment=TA_RIGHT, firstLineIndent=0, leftIndent=0, leading=tamanho_numero+1))
        stylesheet.add(ParagraphStyle(name='EtiquetasRomanPAIS', fontSize=tamanho-1, fontName='Arial', alignment=TA_LEFT, firstLineIndent=0, leftIndent=0, leading=tamanho+1))
        stylesheet.add(ParagraphStyle(name='EtiquetasRoman', fontSize=tamanho, fontName='Arial', alignment=TA_LEFT, firstLineIndent=0, leftIndent=0, leading=tamanho+1))
        
        tamanho = 11
        diferenca = 2
        stylesheet.add(ParagraphStyle(name='EtiquetasRoman24', fontSize=tamanho-diferenca, fontName='Arial', alignment=TA_LEFT, firstLineIndent=0, leftIndent=0, leading=tamanho+1-diferenca))
        stylesheet.add(ParagraphStyle(name='EtiquetasRomanRight24', fontSize=tamanho_numero-diferenca, fontName='Arial', alignment=TA_RIGHT, firstLineIndent=0, leftIndent=0, leading=tamanho_numero+1-diferenca))
        return stylesheet
    
    def add(self, Story):
        self.Story.append(Story)
    
    def build(self):
        self.doc.build(self.Story)
        
    def getToResponse(self):
        ficheiro = file(self.ficheiro_output, "rb")
        return ficheiro.read()