from pyPdf.pdf import PdfFileWriter, PdfFileReader
import os
from reportlab.pdfbase.ttfonts import TTFont
from reportlab.pdfbase import pdfmetrics
from reportlab.lib.fonts import addMapping
from reportlab.pdfgen.canvas import Canvas
from StringIO import StringIO
from reportlab.lib.units import inch
from reportlab.lib.styles import getSampleStyleSheet
from django.utils.translation import ugettext as _
from datetime import date
#from django.template.defaultfilters import date as _date
from datetime import timedelta
from django.http import HttpResponse
from globais.globais import jsonEncode
import random
import datetime
import settings
class MyPDFgen(object):
    
    def getFileName(self,module,ff):
        pasta = '%s%s' % (module,self.getPrefixFilename())
        caminho = '%s'% os.path.abspath(settings.MEDIA_ROOT+pasta)
        try:
            os.makedirs(caminho)
        except:
            pass
        m_file = '%s_%s.pdf' % (ff, self.getSufixFilename())
        ficheiro = '%s/%s' % (caminho, m_file)
        while os.path.exists(ficheiro):
            m_file = '%s_%s.pdf' % (ff, self.getSufixFilename())
            ficheiro = '%s/%s' % (caminho, m_file)
        ficheiro_pdf = self.getDir()+"/pdfs/%s/" % module
        return (ficheiro,ficheiro_pdf,'%s%s' % (pasta, m_file))
    
    def getSufixFilename(self):
        return str(random.random()).replace('.','')
    def getPrefixFilename(self):
        return datetime.datetime.now().strftime('/%Y/%m/%d/')
    
    def getDir(self):
        return os.path.dirname(os.path.abspath(__file__))
       
    def ajustarLinha(self,ponto):
        self.y += ponto
        return self.getLinha()
    
    def getLinha(self):
        return self.y

    def addLinha(self):
        self.y -= (self.tamanho_letra+1)+self.my_leading
        return self.getLinha()   
    
    def trataData2(self, data):
        if data == None or data =='':
            return ''
        return '%s-%s-%s' % (data.strftime("%d"),data.strftime("%m"), data.strftime("%Y"))
    
    def trataData3(self, data):
        if data==None or data =='':
            return ''
        return '%s %s %s %s %s' % (data.strftime("%d"), _("of"), _(data.strftime("%m")), _("of"), data.strftime("%Y"))
    
    def trataData(self, data):
        if data==None or data =='':
            return ''
        return '%s %s %s %s %s' % (data.strftime("%d"), _("of"), _(data.strftime("%B")), _("of"), data.strftime("%Y"))
    
    def trataHora(self, data):
        if data==None or data =='':
            return ''
        return '%s %s %s' % (data.strftime("%H"), _("and"), data.strftime("%M"))
    
    def getIdade(self, data):
        if data==None or data =='':
            return ''
        
        hoje = date.today()
        
        try:
            nascimento = data.replace(year=hoje.year)
        except ValueError:
            nascimento = data.replace(year=hoje.year, day=data.day-1)
        if nascimento > hoje:
            return str(hoje.year - data.year - 1)
        else:
            return str(hoje.year - data.year)
    
    def __init__(self, ficheiro_pdf, ficheiro_output, obj,filename):
        self.obj = obj #Classe a ser usada para preencher o relatorio
        self.ficheiro_output=ficheiro_output
        self.filename = filename
        self.output = PdfFileWriter()
        self.pdf_original = PdfFileReader(file(ficheiro_pdf, "rb"))
        self._loadFonts()
        self._getStyleSheet()
            
    def _getStyleSheet(self):
        #, backColor=colors.aqua
        self.stylesheet = getSampleStyleSheet()
    
    def _loadFonts(self):
        font_folder = os.path.dirname(os.path.abspath(__file__))
        pdfmetrics.registerFont(TTFont('Calibri', '%s/%s' % (font_folder, 'fonts/calibri.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-Bold', '%s/%s' % (font_folder, 'fonts/calibrib.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-Italic', '%s/%s' % (font_folder, 'fonts/calibrii.ttf')))
        pdfmetrics.registerFont(TTFont('Calibri-BoldItalic', '%s/%s' % (font_folder, 'fonts/calibriz.ttf')))

        addMapping('Calibri', 0, 0, 'Calibri')
        addMapping('Calibri', 1, 0, 'Calibri-Bold')
        addMapping('Calibri', 0, 1, 'Calibri-Italic')
        addMapping('Calibri', 1, 1, 'Calibri-BoldItalic')

    
    def _run(self):
        self._buffer = StringIO()
        self._ow, self._oh = (self._w, self._h)
        c = Canvas(self._buffer,bottomup=1, pagesize=(self._w, self._h))
        #c.translate(-1,-1)
        return c
    
    def writePDF(self):
        self._run()
        new_page = PdfFileReader(self._buffer)
            
        for i in range(0,self.pdf_original.numPages):
            pagina = self.pdf_original.getPage(i)
            if new_page.numPages>i:
                pagina.mergePage(new_page.getPage(i))
            self.output.addPage(pagina)
            
        outputStream = file(self.ficheiro_output, "wb")
        self.output.write(outputStream)
        outputStream.close()
    def getFilename(self):
        return self.filename
    def getJsonCreate(self):
        return HttpResponse(jsonEncode({'status':'1','errors':{},'msg':self.filename}), mimetype="application/json")
    def getToResponse(self):
        ficheiro = file(self.ficheiro_output, "rb")
        return ficheiro.read()
